/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.metrics.groups.SlotManagerMetricGroup;
import org.apache.flink.runtime.resourcemanager.DefaultJobLeaderIdService;
import org.apache.flink.runtime.resourcemanager.JobLeaderIdService;
import org.apache.flink.runtime.resourcemanager.ResourceManagerRuntimeServicesConfiguration;
import org.apache.flink.runtime.resourcemanager.slotmanager.DeclarativeSlotManager;
import org.apache.flink.runtime.resourcemanager.slotmanager.DefaultResourceAllocationStrategy;
import org.apache.flink.runtime.resourcemanager.slotmanager.DefaultResourceTracker;
import org.apache.flink.runtime.resourcemanager.slotmanager.DefaultSlotStatusSyncer;
import org.apache.flink.runtime.resourcemanager.slotmanager.DefaultSlotTracker;
import org.apache.flink.runtime.resourcemanager.slotmanager.FineGrainedSlotManager;
import org.apache.flink.runtime.resourcemanager.slotmanager.FineGrainedTaskManagerTracker;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManager;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManagerConfiguration;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManagerImpl;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManagerUtils;
import org.apache.flink.util.Preconditions;

public class ResourceManagerRuntimeServices {
    private static final long REQUIREMENTS_CHECK_DELAY_MS = 50L;
    private final SlotManager slotManager;
    private final JobLeaderIdService jobLeaderIdService;

    public ResourceManagerRuntimeServices(SlotManager slotManager, JobLeaderIdService jobLeaderIdService) {
        this.slotManager = (SlotManager)Preconditions.checkNotNull((Object)slotManager);
        this.jobLeaderIdService = (JobLeaderIdService)Preconditions.checkNotNull((Object)jobLeaderIdService);
    }

    public SlotManager getSlotManager() {
        return this.slotManager;
    }

    public JobLeaderIdService getJobLeaderIdService() {
        return this.jobLeaderIdService;
    }

    public static ResourceManagerRuntimeServices fromConfiguration(ResourceManagerRuntimeServicesConfiguration configuration, HighAvailabilityServices highAvailabilityServices, ScheduledExecutor scheduledExecutor, SlotManagerMetricGroup slotManagerMetricGroup) {
        SlotManager slotManager = ResourceManagerRuntimeServices.createSlotManager(configuration, scheduledExecutor, slotManagerMetricGroup);
        DefaultJobLeaderIdService jobLeaderIdService = new DefaultJobLeaderIdService(highAvailabilityServices, scheduledExecutor, configuration.getJobTimeout());
        return new ResourceManagerRuntimeServices(slotManager, jobLeaderIdService);
    }

    private static SlotManager createSlotManager(ResourceManagerRuntimeServicesConfiguration configuration, ScheduledExecutor scheduledExecutor, SlotManagerMetricGroup slotManagerMetricGroup) {
        SlotManagerConfiguration slotManagerConfiguration = configuration.getSlotManagerConfiguration();
        if (configuration.isEnableFineGrainedResourceManagement()) {
            return new FineGrainedSlotManager(scheduledExecutor, slotManagerConfiguration, slotManagerMetricGroup, new DefaultResourceTracker(), new FineGrainedTaskManagerTracker(), new DefaultSlotStatusSyncer(slotManagerConfiguration.getTaskManagerRequestTimeout()), new DefaultResourceAllocationStrategy(SlotManagerUtils.generateTaskManagerTotalResourceProfile(slotManagerConfiguration.getDefaultWorkerResourceSpec()), slotManagerConfiguration.getNumSlotsPerWorker()), Time.milliseconds((long)50L));
        }
        if (configuration.isDeclarativeResourceManagementEnabled()) {
            return new DeclarativeSlotManager(scheduledExecutor, slotManagerConfiguration, slotManagerMetricGroup, new DefaultResourceTracker(), new DefaultSlotTracker());
        }
        return new SlotManagerImpl(scheduledExecutor, slotManagerConfiguration, slotManagerMetricGroup);
    }
}

