/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph.tasks;

import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.flink.runtime.checkpoint.MasterTriggerRestoreHook;
import org.apache.flink.runtime.jobgraph.tasks.CheckpointCoordinatorConfiguration;
import org.apache.flink.runtime.state.CheckpointStorage;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedValue;

public class JobCheckpointingSettings
implements Serializable {
    private static final long serialVersionUID = -2593319571078198180L;
    private final CheckpointCoordinatorConfiguration checkpointCoordinatorConfiguration;
    @Nullable
    private final SerializedValue<StateBackend> defaultStateBackend;
    @Nullable
    private final SerializedValue<CheckpointStorage> defaultCheckpointStorage;
    @Nullable
    private final SerializedValue<MasterTriggerRestoreHook.Factory[]> masterHooks;

    public JobCheckpointingSettings(CheckpointCoordinatorConfiguration checkpointCoordinatorConfiguration, @Nullable SerializedValue<StateBackend> defaultStateBackend) {
        this(checkpointCoordinatorConfiguration, defaultStateBackend, null, null);
    }

    public JobCheckpointingSettings(CheckpointCoordinatorConfiguration checkpointCoordinatorConfiguration, @Nullable SerializedValue<StateBackend> defaultStateBackend, @Nullable SerializedValue<CheckpointStorage> defaultCheckpointStorage, @Nullable SerializedValue<MasterTriggerRestoreHook.Factory[]> masterHooks) {
        this.checkpointCoordinatorConfiguration = (CheckpointCoordinatorConfiguration)Preconditions.checkNotNull((Object)checkpointCoordinatorConfiguration);
        this.defaultStateBackend = defaultStateBackend;
        this.defaultCheckpointStorage = defaultCheckpointStorage;
        this.masterHooks = masterHooks;
    }

    public CheckpointCoordinatorConfiguration getCheckpointCoordinatorConfiguration() {
        return this.checkpointCoordinatorConfiguration;
    }

    @Nullable
    public SerializedValue<StateBackend> getDefaultStateBackend() {
        return this.defaultStateBackend;
    }

    @Nullable
    public SerializedValue<CheckpointStorage> getDefaultCheckpointStorage() {
        return this.defaultCheckpointStorage;
    }

    @Nullable
    public SerializedValue<MasterTriggerRestoreHook.Factory[]> getMasterHooks() {
        return this.masterHooks;
    }

    public String toString() {
        return String.format("SnapshotSettings: config=%s", this.checkpointCoordinatorConfiguration);
    }
}

