/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.runtime.checkpoint.AbstractCheckpointStats;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CheckpointStatsStatus;
import org.apache.flink.runtime.checkpoint.CheckpointStatsTracker;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStats;
import org.apache.flink.runtime.checkpoint.FailedCheckpointStats;
import org.apache.flink.runtime.checkpoint.SubtaskStateStats;
import org.apache.flink.runtime.checkpoint.TaskStateStats;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.util.Preconditions;

public class PendingCheckpointStats
extends AbstractCheckpointStats {
    private static final long serialVersionUID = -973959257699390327L;
    private final transient CheckpointStatsTracker.PendingCheckpointStatsCallback trackerCallback;
    private volatile int currentNumAcknowledgedSubtasks;
    private volatile long currentStateSize;
    private volatile long currentProcessedData;
    private volatile long currentPersistedData;
    private volatile SubtaskStateStats latestAcknowledgedSubtask;

    PendingCheckpointStats(long checkpointId, long triggerTimestamp, CheckpointProperties props, Map<JobVertexID, Integer> taskStats, CheckpointStatsTracker.PendingCheckpointStatsCallback trackerCallback) {
        this(checkpointId, triggerTimestamp, props, taskStats.values().stream().mapToInt(i -> i).sum(), (Map<JobVertexID, TaskStateStats>)taskStats.entrySet().stream().collect(Collectors.toConcurrentMap(Map.Entry::getKey, e -> new TaskStateStats((JobVertexID)e.getKey(), (Integer)e.getValue()))), trackerCallback);
    }

    PendingCheckpointStats(long checkpointId, long triggerTimestamp, CheckpointProperties props, int totalSubtaskCount, Map<JobVertexID, TaskStateStats> taskStats, CheckpointStatsTracker.PendingCheckpointStatsCallback trackerCallback) {
        this(checkpointId, triggerTimestamp, props, totalSubtaskCount, 0, taskStats, trackerCallback, 0L, 0L, 0L, null);
    }

    PendingCheckpointStats(long checkpointId, long triggerTimestamp, CheckpointProperties props, int totalSubtaskCount, int acknowledgedSubtaskCount, Map<JobVertexID, TaskStateStats> taskStats, CheckpointStatsTracker.PendingCheckpointStatsCallback trackerCallback, long currentStateSize, long processedData, long persistedData, @Nullable SubtaskStateStats latestAcknowledgedSubtask) {
        super(checkpointId, triggerTimestamp, props, totalSubtaskCount, taskStats);
        this.trackerCallback = (CheckpointStatsTracker.PendingCheckpointStatsCallback)Preconditions.checkNotNull((Object)trackerCallback);
        this.currentStateSize = currentStateSize;
        this.currentPersistedData = processedData;
        this.currentPersistedData = persistedData;
        this.latestAcknowledgedSubtask = latestAcknowledgedSubtask;
        this.currentNumAcknowledgedSubtasks = acknowledgedSubtaskCount;
    }

    @Override
    public CheckpointStatsStatus getStatus() {
        return CheckpointStatsStatus.IN_PROGRESS;
    }

    @Override
    public int getNumberOfAcknowledgedSubtasks() {
        return this.currentNumAcknowledgedSubtasks;
    }

    @Override
    public long getStateSize() {
        return this.currentStateSize;
    }

    @Override
    public long getProcessedData() {
        return this.currentProcessedData;
    }

    @Override
    public long getPersistedData() {
        return this.currentPersistedData;
    }

    @Override
    public SubtaskStateStats getLatestAcknowledgedSubtaskStats() {
        return this.latestAcknowledgedSubtask;
    }

    boolean reportSubtaskStats(JobVertexID jobVertexId, SubtaskStateStats subtask) {
        TaskStateStats taskStateStats = (TaskStateStats)this.taskStats.get(jobVertexId);
        if (taskStateStats != null && taskStateStats.reportSubtaskStats(subtask)) {
            long persistedData;
            if (subtask.isCompleted()) {
                ++this.currentNumAcknowledgedSubtasks;
                this.latestAcknowledgedSubtask = subtask;
            }
            this.currentStateSize += subtask.getStateSize();
            long processedData = subtask.getProcessedData();
            if (processedData > 0L) {
                this.currentProcessedData += processedData;
            }
            if ((persistedData = subtask.getPersistedData()) > 0L) {
                this.currentPersistedData += persistedData;
            }
            return true;
        }
        return false;
    }

    CompletedCheckpointStats.DiscardCallback reportCompletedCheckpoint(String externalPointer) {
        CompletedCheckpointStats completed = new CompletedCheckpointStats(this.checkpointId, this.triggerTimestamp, this.props, this.numberOfSubtasks, new HashMap<JobVertexID, TaskStateStats>(this.taskStats), this.currentNumAcknowledgedSubtasks, this.currentStateSize, this.currentProcessedData, this.currentPersistedData, this.latestAcknowledgedSubtask, externalPointer);
        this.trackerCallback.reportCompletedCheckpoint(completed);
        return completed.getDiscardCallback();
    }

    void reportFailedCheckpoint(long failureTimestamp, @Nullable Throwable cause) {
        FailedCheckpointStats failed = new FailedCheckpointStats(this.checkpointId, this.triggerTimestamp, this.props, this.numberOfSubtasks, new HashMap<JobVertexID, TaskStateStats>(this.taskStats), this.currentNumAcknowledgedSubtasks, this.currentStateSize, this.currentProcessedData, this.currentPersistedData, failureTimestamp, this.latestAcknowledgedSubtask, cause);
        this.trackerCallback.reportFailedCheckpoint(failed);
    }

    public String toString() {
        return "PendingCheckpoint(id=" + this.getCheckpointId() + ")";
    }
}

