/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

public enum CheckpointType {
    CHECKPOINT(false, PostCheckpointAction.NONE, "Checkpoint"),
    SAVEPOINT(true, PostCheckpointAction.NONE, "Savepoint"),
    SAVEPOINT_SUSPEND(true, PostCheckpointAction.SUSPEND, "Suspend Savepoint"),
    SAVEPOINT_TERMINATE(true, PostCheckpointAction.TERMINATE, "Terminate Savepoint");

    private final boolean isSavepoint;
    private final PostCheckpointAction postCheckpointAction;
    private final String name;

    private CheckpointType(boolean isSavepoint, PostCheckpointAction postCheckpointAction, String name) {
        this.isSavepoint = isSavepoint;
        this.postCheckpointAction = postCheckpointAction;
        this.name = name;
    }

    public boolean isSavepoint() {
        return this.isSavepoint;
    }

    public boolean isSynchronous() {
        return this.postCheckpointAction != PostCheckpointAction.NONE;
    }

    public PostCheckpointAction getPostCheckpointAction() {
        return this.postCheckpointAction;
    }

    public boolean shouldAdvanceToEndOfTime() {
        return this.getPostCheckpointAction() == PostCheckpointAction.TERMINATE;
    }

    public boolean shouldIgnoreEndOfInput() {
        return this.getPostCheckpointAction() == PostCheckpointAction.SUSPEND;
    }

    public String getName() {
        return this.name;
    }

    public static enum PostCheckpointAction {
        NONE,
        SUSPEND,
        TERMINATE;

    }
}

