/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.flink.runtime.checkpoint.CheckpointStatsCounts;
import org.apache.flink.runtime.checkpoint.CheckpointStatsHistory;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStatsSummary;
import org.apache.flink.runtime.checkpoint.RestoredCheckpointStats;
import org.apache.flink.util.Preconditions;

public class CheckpointStatsSnapshot
implements Serializable {
    private static final long serialVersionUID = 8914278419087217964L;
    private final CheckpointStatsCounts counts;
    private final CompletedCheckpointStatsSummary summary;
    private final CheckpointStatsHistory history;
    @Nullable
    private final RestoredCheckpointStats latestRestoredCheckpoint;

    public static CheckpointStatsSnapshot empty() {
        return new CheckpointStatsSnapshot(new CheckpointStatsCounts(), new CompletedCheckpointStatsSummary(), new CheckpointStatsHistory(0), null);
    }

    CheckpointStatsSnapshot(CheckpointStatsCounts counts, CompletedCheckpointStatsSummary summary, CheckpointStatsHistory history, @Nullable RestoredCheckpointStats latestRestoredCheckpoint) {
        this.counts = (CheckpointStatsCounts)Preconditions.checkNotNull((Object)counts);
        this.summary = (CompletedCheckpointStatsSummary)Preconditions.checkNotNull((Object)summary);
        this.history = (CheckpointStatsHistory)Preconditions.checkNotNull((Object)history);
        this.latestRestoredCheckpoint = latestRestoredCheckpoint;
    }

    public CheckpointStatsCounts getCounts() {
        return this.counts;
    }

    public CompletedCheckpointStatsSummary getSummaryStats() {
        return this.summary;
    }

    public CheckpointStatsHistory getHistory() {
        return this.history;
    }

    @Nullable
    public RestoredCheckpointStats getLatestRestoredCheckpoint() {
        return this.latestRestoredCheckpoint;
    }
}

