/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.StateSnapshot;
import org.apache.flink.runtime.state.StateSnapshotTransformer;
import org.apache.flink.runtime.state.heap.StateMap;
import org.apache.flink.runtime.state.heap.StateMapSnapshot;
import org.apache.flink.runtime.state.heap.StateTable;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshot;
import org.apache.flink.util.Preconditions;

@Internal
abstract class AbstractStateTableSnapshot<K, N, S>
implements StateSnapshot,
StateSnapshot.StateKeyGroupWriter {
    protected final StateTable<K, N, S> owningStateTable;
    @Nonnull
    protected final TypeSerializer<K> localKeySerializer;
    @Nonnull
    protected final TypeSerializer<N> localNamespaceSerializer;
    @Nonnull
    protected final TypeSerializer<S> localStateSerializer;
    @Nullable
    protected final StateSnapshotTransformer<S> stateSnapshotTransformer;

    AbstractStateTableSnapshot(StateTable<K, N, S> owningStateTable, TypeSerializer<K> localKeySerializer, TypeSerializer<N> localNamespaceSerializer, TypeSerializer<S> localStateSerializer, @Nullable StateSnapshotTransformer<S> stateSnapshotTransformer) {
        this.owningStateTable = (StateTable)Preconditions.checkNotNull(owningStateTable);
        this.localKeySerializer = (TypeSerializer)Preconditions.checkNotNull(localKeySerializer);
        this.localNamespaceSerializer = (TypeSerializer)Preconditions.checkNotNull(localNamespaceSerializer);
        this.localStateSerializer = (TypeSerializer)Preconditions.checkNotNull(localStateSerializer);
        this.stateSnapshotTransformer = stateSnapshotTransformer;
    }

    protected abstract StateMapSnapshot<K, N, S, ? extends StateMap<K, N, S>> getStateMapSnapshotForKeyGroup(int var1);

    @Override
    @Nonnull
    public StateMetaInfoSnapshot getMetaInfoSnapshot() {
        return this.owningStateTable.getMetaInfo().snapshot();
    }

    @Override
    public StateSnapshot.StateKeyGroupWriter getKeyGroupWriter() {
        return this;
    }

    @Override
    public void writeStateInKeyGroup(@Nonnull DataOutputView dov, int keyGroupId) throws IOException {
        StateMapSnapshot<K, N, S, StateMap<K, N, S>> stateMapSnapshot = this.getStateMapSnapshotForKeyGroup(keyGroupId);
        stateMapSnapshot.writeState(this.localKeySerializer, this.localNamespaceSerializer, this.localStateSerializer, dov, this.stateSnapshotTransformer);
        stateMapSnapshot.release();
    }
}

