/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.shuffle;

import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.shuffle.NettyShuffleDescriptor;
import org.apache.flink.runtime.shuffle.PartitionDescriptor;
import org.apache.flink.runtime.shuffle.ProducerDescriptor;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;
import org.apache.flink.runtime.shuffle.ShuffleMaster;

public enum NettyShuffleMaster implements ShuffleMaster<NettyShuffleDescriptor>
{
    INSTANCE;


    @Override
    public CompletableFuture<NettyShuffleDescriptor> registerPartitionWithProducer(PartitionDescriptor partitionDescriptor, ProducerDescriptor producerDescriptor) {
        ResultPartitionID resultPartitionID = new ResultPartitionID(partitionDescriptor.getPartitionId(), producerDescriptor.getProducerExecutionId());
        NettyShuffleDescriptor shuffleDeploymentDescriptor = new NettyShuffleDescriptor(producerDescriptor.getProducerLocation(), NettyShuffleMaster.createConnectionInfo(producerDescriptor, partitionDescriptor.getConnectionIndex()), resultPartitionID);
        return CompletableFuture.completedFuture(shuffleDeploymentDescriptor);
    }

    @Override
    public void releasePartitionExternally(ShuffleDescriptor shuffleDescriptor) {
    }

    private static NettyShuffleDescriptor.PartitionConnectionInfo createConnectionInfo(ProducerDescriptor producerDescriptor, int connectionIndex) {
        return producerDescriptor.getDataPort() >= 0 ? NettyShuffleDescriptor.NetworkPartitionConnectionInfo.fromProducerDescriptor(producerDescriptor, connectionIndex) : NettyShuffleDescriptor.LocalExecutionPartitionConnectionInfo.INSTANCE;
    }
}

