/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.security;

import java.security.Permission;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.flink.configuration.ClusterOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.util.Preconditions;

public final class ExitTrappingSecurityManager
extends SecurityManager {
    private final Consumer<Integer> onExitBehavior;
    @Nullable
    private final SecurityManager existingManager;

    public ExitTrappingSecurityManager(Consumer<Integer> onExitBehavior, @Nullable SecurityManager existingManager) {
        this.onExitBehavior = (Consumer)Preconditions.checkNotNull(onExitBehavior);
        this.existingManager = existingManager;
    }

    @Override
    public void checkExit(int status) {
        if (this.existingManager != null) {
            this.existingManager.checkExit(status);
        }
        System.setSecurityManager(null);
        this.onExitBehavior.accept(status);
    }

    @Override
    public void checkPermission(Permission perm) {
        if (this.existingManager != null) {
            this.existingManager.checkPermission(perm);
        }
    }

    public static void replaceGracefulExitWithHaltIfConfigured(Configuration configuration) {
        if (((Boolean)configuration.get(ClusterOptions.HALT_ON_FATAL_ERROR)).booleanValue()) {
            ExitTrappingSecurityManager forcefulShutdownManager = new ExitTrappingSecurityManager(status -> Runtime.getRuntime().halt((int)status), System.getSecurityManager());
            try {
                System.setSecurityManager(forcefulShutdownManager);
            }
            catch (Exception e) {
                throw new IllegalConfigurationException(String.format("Could not register forceful shutdown handler. This feature requires the permission to set a SecurityManager. Either update your existing SecurityManager to allow setting a SecurityManager or disable this feature by updating your Flink config with the following: '%s: %s'", ClusterOptions.HALT_ON_FATAL_ERROR.key(), ClusterOptions.HALT_ON_FATAL_ERROR.defaultValue()), (Throwable)e);
            }
        }
    }
}

