/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.queryablestate.KvStateID;
import org.apache.flink.runtime.accumulators.AccumulatorSnapshot;
import org.apache.flink.runtime.checkpoint.CheckpointMetrics;
import org.apache.flink.runtime.checkpoint.TaskStateSnapshot;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.JobStatusListener;
import org.apache.flink.runtime.executiongraph.TaskExecutionStateTransition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobmanager.PartitionProducerDisposedException;
import org.apache.flink.runtime.jobmaster.SerializedInputSplit;
import org.apache.flink.runtime.messages.FlinkJobNotFoundException;
import org.apache.flink.runtime.messages.checkpoint.DeclineCheckpoint;
import org.apache.flink.runtime.messages.webmonitor.JobDetails;
import org.apache.flink.runtime.operators.coordination.CoordinationRequest;
import org.apache.flink.runtime.operators.coordination.CoordinationResponse;
import org.apache.flink.runtime.operators.coordination.OperatorEvent;
import org.apache.flink.runtime.query.KvStateLocation;
import org.apache.flink.runtime.query.UnknownKvStateLocation;
import org.apache.flink.runtime.rest.handler.legacy.backpressure.OperatorBackPressureStats;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.taskmanager.TaskExecutionState;
import org.apache.flink.util.FlinkException;

public interface SchedulerNG {
    public void setMainThreadExecutor(ComponentMainThreadExecutor var1);

    public void registerJobStatusListener(JobStatusListener var1);

    public void startScheduling();

    public void suspend(Throwable var1);

    public void cancel();

    public CompletableFuture<Void> getTerminationFuture();

    public void handleGlobalFailure(Throwable var1);

    default public boolean updateTaskExecutionState(TaskExecutionState taskExecutionState) {
        return this.updateTaskExecutionState(new TaskExecutionStateTransition(taskExecutionState));
    }

    public boolean updateTaskExecutionState(TaskExecutionStateTransition var1);

    public SerializedInputSplit requestNextInputSplit(JobVertexID var1, ExecutionAttemptID var2) throws IOException;

    public ExecutionState requestPartitionState(IntermediateDataSetID var1, ResultPartitionID var2) throws PartitionProducerDisposedException;

    public void scheduleOrUpdateConsumers(ResultPartitionID var1);

    public ArchivedExecutionGraph requestJob();

    public JobStatus requestJobStatus();

    public JobDetails requestJobDetails();

    public KvStateLocation requestKvStateLocation(JobID var1, String var2) throws UnknownKvStateLocation, FlinkJobNotFoundException;

    public void notifyKvStateRegistered(JobID var1, JobVertexID var2, KeyGroupRange var3, String var4, KvStateID var5, InetSocketAddress var6) throws FlinkJobNotFoundException;

    public void notifyKvStateUnregistered(JobID var1, JobVertexID var2, KeyGroupRange var3, String var4) throws FlinkJobNotFoundException;

    public void updateAccumulators(AccumulatorSnapshot var1);

    public Optional<OperatorBackPressureStats> requestOperatorBackPressureStats(JobVertexID var1) throws FlinkException;

    public CompletableFuture<String> triggerSavepoint(@Nullable String var1, boolean var2);

    public void acknowledgeCheckpoint(JobID var1, ExecutionAttemptID var2, long var3, CheckpointMetrics var5, TaskStateSnapshot var6);

    public void declineCheckpoint(DeclineCheckpoint var1);

    public CompletableFuture<String> stopWithSavepoint(String var1, boolean var2);

    public void deliverOperatorEventToCoordinator(ExecutionAttemptID var1, OperatorID var2, OperatorEvent var3) throws FlinkException;

    public CompletableFuture<CoordinationResponse> deliverCoordinationRequestToCoordinator(OperatorID var1, CoordinationRequest var2) throws FlinkException;
}

