/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy.backpressure;

import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnegative;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.util.Preconditions;

public class BackPressureStats {
    private final int requestId;
    private final long startTime;
    private final long endTime;
    private final Map<ExecutionAttemptID, Double> backPressureRatios;

    public BackPressureStats(@Nonnegative int requestId, @Nonnegative long startTime, @Nonnegative long endTime, Map<ExecutionAttemptID, Double> backPressureRatios) {
        Preconditions.checkArgument((endTime >= startTime ? 1 : 0) != 0, (Object)"End time must not before start time.");
        this.requestId = requestId;
        this.startTime = startTime;
        this.endTime = endTime;
        this.backPressureRatios = Collections.unmodifiableMap((Map)Preconditions.checkNotNull(backPressureRatios));
    }

    public int getRequestId() {
        return this.requestId;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public Map<ExecutionAttemptID, Double> getBackPressureRatios() {
        return this.backPressureRatios;
    }

    public String toString() {
        return "BackPressureStats{requestId=" + this.requestId + ", startTime=" + this.startTime + ", endTime=" + this.endTime + '}';
    }
}

