/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.resourcemanager.slotmanager.JobScopedResourceTracker;
import org.apache.flink.runtime.resourcemanager.slotmanager.ResourceTracker;
import org.apache.flink.runtime.slots.ResourceRequirement;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultResourceTracker
implements ResourceTracker {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultResourceTracker.class);
    private final Map<JobID, JobScopedResourceTracker> trackers = new HashMap<JobID, JobScopedResourceTracker>();

    @Override
    public void notifyResourceRequirements(JobID jobId, Collection<ResourceRequirement> resourceRequirements) {
        Preconditions.checkNotNull((Object)jobId);
        Preconditions.checkNotNull(resourceRequirements);
        LOG.trace("Received notification for job {} having new resource requirements {}.", (Object)jobId, resourceRequirements);
        this.getOrCreateTracker(jobId).notifyResourceRequirements(resourceRequirements);
        if (resourceRequirements.isEmpty()) {
            this.checkWhetherTrackerCanBeRemoved(jobId, this.trackers.get(jobId));
        }
    }

    private void checkWhetherTrackerCanBeRemoved(JobID jobId, JobScopedResourceTracker tracker) {
        if (tracker.isEmpty()) {
            LOG.debug("Stopping tracking of resources for job {}.", (Object)jobId);
            this.trackers.remove(jobId);
        }
    }

    @Override
    public void notifyAcquiredResource(JobID jobId, ResourceProfile resourceProfile) {
        Preconditions.checkNotNull((Object)jobId);
        Preconditions.checkNotNull((Object)resourceProfile);
        LOG.trace("Received notification for job {} having acquired resource {}.", (Object)jobId, (Object)resourceProfile);
        this.getOrCreateTracker(jobId).notifyAcquiredResource(resourceProfile);
    }

    private JobScopedResourceTracker getOrCreateTracker(JobID jobId) {
        return this.trackers.computeIfAbsent(jobId, ignored -> {
            LOG.debug("Initiating tracking of resources for job {}.", (Object)jobId);
            return new JobScopedResourceTracker(jobId);
        });
    }

    @Override
    public void notifyLostResource(JobID jobId, ResourceProfile resourceProfile) {
        Preconditions.checkNotNull((Object)jobId);
        Preconditions.checkNotNull((Object)resourceProfile);
        JobScopedResourceTracker tracker = this.trackers.get(jobId);
        if (tracker != null) {
            LOG.trace("Received notification for job {} having lost resource {}.", (Object)jobId, (Object)resourceProfile);
            tracker.notifyLostResource(resourceProfile);
            this.checkWhetherTrackerCanBeRemoved(jobId, tracker);
        } else {
            LOG.trace("Received notification for job {} having lost resource {}, but no such job was tracked.", (Object)jobId, (Object)resourceProfile);
        }
    }

    @Override
    public void clear() {
        this.trackers.clear();
    }

    @Override
    public Map<JobID, Collection<ResourceRequirement>> getMissingResources() {
        HashMap<JobID, Collection<ResourceRequirement>> allMissingResources = new HashMap<JobID, Collection<ResourceRequirement>>();
        for (Map.Entry<JobID, JobScopedResourceTracker> tracker : this.trackers.entrySet()) {
            Collection<ResourceRequirement> missingResources = tracker.getValue().getMissingResources();
            if (missingResources.isEmpty()) continue;
            allMissingResources.put(tracker.getKey(), missingResources);
        }
        return allMissingResources;
    }

    @Override
    public Collection<ResourceRequirement> getAcquiredResources(JobID jobId) {
        Preconditions.checkNotNull((Object)jobId);
        JobScopedResourceTracker tracker = this.trackers.get(jobId);
        return tracker == null ? Collections.emptyList() : tracker.getAcquiredResources();
    }

    @VisibleForTesting
    boolean isEmpty() {
        return this.trackers.isEmpty();
    }
}

