/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotID;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.resourcemanager.registration.TaskExecutorConnection;
import org.apache.flink.runtime.resourcemanager.slotmanager.PendingSlotRequest;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotState;
import org.apache.flink.runtime.resourcemanager.slotmanager.TaskManagerSlotInformation;
import org.apache.flink.util.Preconditions;

public class TaskManagerSlot
implements TaskManagerSlotInformation {
    private final SlotID slotId;
    private final ResourceProfile resourceProfile;
    private final TaskExecutorConnection taskManagerConnection;
    @Nullable
    private AllocationID allocationId;
    @Nullable
    private JobID jobId;
    private PendingSlotRequest assignedSlotRequest;
    private SlotState state;

    public TaskManagerSlot(SlotID slotId, ResourceProfile resourceProfile, TaskExecutorConnection taskManagerConnection) {
        this.slotId = (SlotID)Preconditions.checkNotNull((Object)slotId);
        this.resourceProfile = (ResourceProfile)Preconditions.checkNotNull((Object)resourceProfile);
        this.taskManagerConnection = (TaskExecutorConnection)Preconditions.checkNotNull((Object)taskManagerConnection);
        this.state = SlotState.FREE;
        this.allocationId = null;
        this.assignedSlotRequest = null;
    }

    @Override
    public SlotState getState() {
        return this.state;
    }

    @Override
    public SlotID getSlotId() {
        return this.slotId;
    }

    @Override
    public ResourceProfile getResourceProfile() {
        return this.resourceProfile;
    }

    @Override
    public TaskExecutorConnection getTaskManagerConnection() {
        return this.taskManagerConnection;
    }

    @Override
    @Nullable
    public AllocationID getAllocationId() {
        return this.allocationId;
    }

    @Override
    @Nullable
    public JobID getJobId() {
        return this.jobId;
    }

    public PendingSlotRequest getAssignedSlotRequest() {
        return this.assignedSlotRequest;
    }

    @Override
    public InstanceID getInstanceId() {
        return this.taskManagerConnection.getInstanceID();
    }

    public void freeSlot() {
        Preconditions.checkState((this.state == SlotState.ALLOCATED ? 1 : 0) != 0, (Object)"Slot must be allocated before freeing it.");
        this.state = SlotState.FREE;
        this.allocationId = null;
        this.jobId = null;
    }

    public void clearPendingSlotRequest() {
        Preconditions.checkState((this.state == SlotState.PENDING ? 1 : 0) != 0, (Object)"No slot request to clear.");
        this.state = SlotState.FREE;
        this.assignedSlotRequest = null;
    }

    public void assignPendingSlotRequest(PendingSlotRequest pendingSlotRequest) {
        Preconditions.checkState((this.state == SlotState.FREE ? 1 : 0) != 0, (Object)"Slot must be free to be assigned a slot request.");
        this.state = SlotState.PENDING;
        this.assignedSlotRequest = (PendingSlotRequest)Preconditions.checkNotNull((Object)pendingSlotRequest);
    }

    public void completeAllocation(AllocationID allocationId, JobID jobId) {
        Preconditions.checkNotNull((Object)((Object)allocationId), (String)"Allocation id must not be null.");
        Preconditions.checkNotNull((Object)jobId, (String)"Job id must not be null.");
        Preconditions.checkState((this.state == SlotState.PENDING ? 1 : 0) != 0, (Object)"In order to complete an allocation, the slot has to be allocated.");
        Preconditions.checkState((boolean)Objects.equals((Object)allocationId, (Object)this.assignedSlotRequest.getAllocationId()), (Object)"Mismatch between allocation id of the pending slot request.");
        this.state = SlotState.ALLOCATED;
        this.allocationId = allocationId;
        this.jobId = jobId;
        this.assignedSlotRequest = null;
    }

    public void updateAllocation(AllocationID allocationId, JobID jobId) {
        Preconditions.checkState((this.state == SlotState.FREE ? 1 : 0) != 0, (Object)"The slot has to be free in order to set an allocation id.");
        this.state = SlotState.ALLOCATED;
        this.allocationId = (AllocationID)((Object)Preconditions.checkNotNull((Object)((Object)allocationId)));
        this.jobId = (JobID)Preconditions.checkNotNull((Object)jobId);
    }
}

