/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.com.caucho.hessian.io.java8;

import com.alibaba.com.caucho.hessian.io.AbstractHessianOutput;
import com.alibaba.com.caucho.hessian.io.AbstractSerializer;
import com.alibaba.com.caucho.hessian.io.java8.LocalDateTimeHandle;
import com.alibaba.com.caucho.hessian.io.java8.SerializationConfig;
import java.io.IOException;
import java.time.LocalDateTime;

public class LocalDateTimeSerializer<T>
extends AbstractSerializer {
    @Override
    public void writeObject(Object obj, AbstractHessianOutput out) throws IOException {
        if (obj == null) {
            out.writeNull();
            return;
        }
        if (SerializationConfig.isCompactMode()) {
            if (out.addRef(obj)) {
                return;
            }
            Class<?> cl = obj.getClass();
            int ref = out.writeObjectBegin(cl.getName());
            LocalDateTime localDateTime = (LocalDateTime)obj;
            if (ref < -1) {
                out.writeString("date");
                out.writeLong(localDateTime.toLocalDate().toEpochDay());
                out.writeString("time");
                out.writeLong(localDateTime.toLocalTime().toNanoOfDay());
                out.writeMapEnd();
            } else {
                if (ref == -1) {
                    out.writeInt(2);
                    out.writeString("date");
                    out.writeString("time");
                    out.writeObjectBegin(cl.getName());
                }
                out.writeLong(localDateTime.toLocalDate().toEpochDay());
                out.writeLong(localDateTime.toLocalTime().toNanoOfDay());
            }
        } else {
            out.writeObject(new LocalDateTimeHandle(obj));
        }
    }
}

