/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.com.caucho.hessian.io.java8;

import com.alibaba.com.caucho.hessian.io.AbstractDeserializer;
import com.alibaba.com.caucho.hessian.io.AbstractHessianInput;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;

public class LocalDateTimeDeserializer
extends AbstractDeserializer {
    @Override
    public Object readObject(AbstractHessianInput in, Object[] fieldNames) throws IOException {
        LocalDate localDate = null;
        LocalTime localTime = null;
        for (Object fieldName : fieldNames) {
            if ("date".equals(fieldName)) {
                localDate = LocalDate.ofEpochDay(in.readLong());
                continue;
            }
            if ("time".equals(fieldName)) {
                localTime = LocalTime.ofNanoOfDay(in.readLong());
                continue;
            }
            in.readObject();
        }
        if (localDate == null || localTime == null) {
            throw new IOException("Missing required fields for LocalDateTime deserialization: date=" + localDate + ", time=" + localTime);
        }
        LocalDateTime localDateTime = LocalDateTime.of(localDate, localTime);
        in.addRef(localDateTime);
        return localDateTime;
    }
}

