/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.com.caucho.hessian.io;

import com.alibaba.com.caucho.hessian.HessianException;
import com.alibaba.com.caucho.hessian.io.AbstractHessianOutput;
import com.alibaba.com.caucho.hessian.io.AbstractSerializer;
import com.alibaba.com.caucho.hessian.io.EnumSetHandler;
import com.alibaba.com.caucho.hessian.io.HessianFieldException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.EnumSet;
import java.util.logging.Level;
import sun.misc.Unsafe;

public class EnumSetSerializer
extends AbstractSerializer {
    private static final boolean _isEnabled;
    private static Unsafe _unsafe;
    private static long _elementTypeOffset;

    @Override
    public void writeObject(Object obj, AbstractHessianOutput out) throws IOException {
        if (obj == null) {
            out.writeNull();
        } else {
            EnumSet enumSet = (EnumSet)obj;
            Class<?> type = this.getElementClass(enumSet);
            Object[] objects = enumSet.toArray();
            out.writeObject(new EnumSetHandler(type, objects));
        }
    }

    private Class<?> getElementClass(EnumSet enumSet) throws IOException {
        if (!_isEnabled) {
            if (enumSet.isEmpty()) {
                throw new HessianFieldException("Unable to serialize empty EnumSet without unsafe access");
            }
            return enumSet.iterator().next().getClass();
        }
        try {
            return (Class)_unsafe.getObject(enumSet, _elementTypeOffset);
        }
        catch (Throwable e) {
            throw new HessianException(e);
        }
    }

    static {
        boolean isEnabled = false;
        try {
            Class<?> unsafe = Class.forName("sun.misc.Unsafe");
            Field theUnsafe = null;
            for (Field field : unsafe.getDeclaredFields()) {
                if (!field.getName().equals("theUnsafe")) continue;
                theUnsafe = field;
            }
            if (theUnsafe != null) {
                theUnsafe.setAccessible(true);
                _unsafe = (Unsafe)theUnsafe.get(null);
            }
            isEnabled = _unsafe != null;
            String unsafeProp = System.getProperty("com.caucho.hessian.unsafe");
            if ("false".equals(unsafeProp)) {
                isEnabled = false;
            }
            if (isEnabled) {
                Field elementType = EnumSet.class.getDeclaredField("elementType");
                _elementTypeOffset = _unsafe.objectFieldOffset(elementType);
            }
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
        }
        _isEnabled = isEnabled;
    }
}

