/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.com.caucho.hessian.io;

import com.alibaba.com.caucho.hessian.io.AbstractDeserializer;
import com.alibaba.com.caucho.hessian.io.AbstractHessianInput;
import com.alibaba.com.caucho.hessian.io.FieldDeserializer2Factory;
import com.alibaba.com.caucho.hessian.io.IOExceptionWrapper;
import com.alibaba.com.caucho.hessian.io.RecordUtil;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RecordDeserializer
extends AbstractDeserializer {
    private RecordUtil.RecordComponent[] _components;
    private Map<String, RecordUtil.RecordComponent> _componentMap;
    private Constructor _constructor;
    private Class _cl;

    public RecordDeserializer(Class cl, FieldDeserializer2Factory fieldFactory) {
        this._cl = cl;
        this._components = RecordUtil.getRecordComponents(cl);
        this._constructor = RecordUtil.getCanonicalConstructor(cl);
        this._componentMap = new ConcurrentHashMap<String, RecordUtil.RecordComponent>();
        for (RecordUtil.RecordComponent component : this._components) {
            this._componentMap.put(component.name(), component);
        }
    }

    @Override
    public Class<?> getType() {
        return this._cl;
    }

    @Override
    public Object readObject(AbstractHessianInput in, Object[] fields) throws IOException {
        try {
            return this.readObject(in, (String[])fields);
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOExceptionWrapper(this._cl.getName() + ":" + e, e);
        }
    }

    @Override
    public Object readObject(AbstractHessianInput in, String[] fieldNames) throws IOException {
        try {
            Object[] args = new Object[this._components.length];
            boolean[] readedIndex = new boolean[this._components.length];
            for (String fieldName : fieldNames) {
                Object target;
                RecordUtil.RecordComponent component = this._componentMap.get(fieldName);
                if (component == null) {
                    in.readObject();
                    continue;
                }
                args[component.index()] = target = in.readObject(component.type());
                readedIndex[component.index()] = true;
            }
            for (int i = 0; i < readedIndex.length; ++i) {
                if (readedIndex[i]) continue;
                args[i] = RecordDeserializer.getParamArg(this._components[i].type());
            }
            Object obj = this._constructor.newInstance(args);
            in.addRef(obj);
            return obj;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOExceptionWrapper(this._cl.getName() + ":" + e, e);
        }
    }

    protected static Object getParamArg(Class<?> cl) {
        if (!cl.isPrimitive()) {
            return null;
        }
        if (Boolean.TYPE.equals(cl)) {
            return Boolean.FALSE;
        }
        if (Byte.TYPE.equals(cl)) {
            return (byte)0;
        }
        if (Short.TYPE.equals(cl)) {
            return (short)0;
        }
        if (Character.TYPE.equals(cl)) {
            return Character.valueOf('\u0000');
        }
        if (Integer.TYPE.equals(cl)) {
            return 0;
        }
        if (Long.TYPE.equals(cl)) {
            return 0L;
        }
        if (Float.TYPE.equals(cl)) {
            return Float.valueOf(0.0f);
        }
        if (Double.TYPE.equals(cl)) {
            return 0.0;
        }
        throw new UnsupportedOperationException();
    }
}

