/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.mock.api;

import java.io.Serializable;
import java.util.Arrays;

public class MockContext
implements Serializable {
    private String serviceName;
    private String methodName;
    private Object[] arguments;

    public MockContext() {
    }

    private MockContext(Builder builder) {
        this.serviceName = builder.serviceName;
        this.methodName = builder.methodName;
        this.arguments = builder.arguments;
    }

    public static Builder newMockContext() {
        return new Builder();
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public void setArguments(Object[] arguments) {
        this.arguments = arguments;
    }

    public String toString() {
        return "MockContext{serviceName='" + this.serviceName + '\'' + ", methodName='" + this.methodName + '\'' + ", arguments=" + Arrays.toString(this.arguments) + '}';
    }

    public static final class Builder {
        private String serviceName;
        private String methodName;
        private Object[] arguments;

        private Builder() {
        }

        public MockContext build() {
            return new MockContext(this);
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder methodName(String methodName) {
            this.methodName = methodName;
            return this;
        }

        public Builder arguments(Object[] arguments) {
            this.arguments = arguments;
            return this;
        }
    }
}

