/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.websocket.jakarta;

import jakarta.websocket.CloseReason;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.Session;
import java.io.InputStream;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.io.StreamUtils;
import org.apache.dubbo.config.context.ConfigManager;
import org.apache.dubbo.config.nested.TripleConfig;
import org.apache.dubbo.remoting.http12.HttpHeaderNames;
import org.apache.dubbo.remoting.http12.HttpHeaders;
import org.apache.dubbo.remoting.http12.HttpInputMessage;
import org.apache.dubbo.remoting.http12.HttpMetadata;
import org.apache.dubbo.remoting.http12.HttpMethods;
import org.apache.dubbo.remoting.http12.HttpStatus;
import org.apache.dubbo.remoting.http12.h2.H2StreamChannel;
import org.apache.dubbo.remoting.http12.h2.Http2InputMessageFrame;
import org.apache.dubbo.remoting.http12.h2.Http2MetadataFrame;
import org.apache.dubbo.remoting.http12.message.DefaultHttpHeaders;
import org.apache.dubbo.remoting.websocket.WebSocketTransportListener;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.ServletExchanger;
import org.apache.dubbo.rpc.protocol.tri.websocket.DefaultWebSocketServerTransportListenerFactory;
import org.apache.dubbo.rpc.protocol.tri.websocket.jakarta.TripleBinaryMessageHandler;
import org.apache.dubbo.rpc.protocol.tri.websocket.jakarta.TripleTextMessageHandler;
import org.apache.dubbo.rpc.protocol.tri.websocket.jakarta.WebSocketStreamChannel;

public class TripleEndpoint
extends Endpoint {
    public void onOpen(Session session, EndpointConfig config) {
        String path = session.getRequestURI().getPath();
        DefaultHttpHeaders httpHeaders = new DefaultHttpHeaders();
        httpHeaders.set((CharSequence)HttpHeaderNames.PATH.getName(), path);
        httpHeaders.set((CharSequence)HttpHeaderNames.METHOD.getName(), HttpMethods.POST.name());
        Http2MetadataFrame http2Header = new Http2MetadataFrame((HttpHeaders)httpHeaders);
        URL url = ServletExchanger.getUrl();
        TripleConfig tripleConfig = ConfigManager.getProtocolOrDefault((URL)url).getTripleOrDefault();
        WebSocketStreamChannel webSocketStreamChannel = new WebSocketStreamChannel(session, tripleConfig);
        WebSocketTransportListener webSocketTransportListener = DefaultWebSocketServerTransportListenerFactory.INSTANCE.newInstance((H2StreamChannel)webSocketStreamChannel, url, FrameworkModel.defaultModel());
        webSocketTransportListener.onMetadata((HttpMetadata)http2Header);
        session.addMessageHandler((MessageHandler)new TripleTextMessageHandler(webSocketTransportListener));
        session.addMessageHandler((MessageHandler)new TripleBinaryMessageHandler(webSocketTransportListener));
        session.getUserProperties().put("tri.websocket.listener", webSocketTransportListener);
    }

    public void onClose(Session session, CloseReason closeReason) {
        super.onClose(session, closeReason);
        WebSocketTransportListener webSocketTransportListener = (WebSocketTransportListener)session.getUserProperties().get("tri.websocket.listener");
        if (webSocketTransportListener == null) {
            return;
        }
        if (closeReason.getCloseCode().getCode() == CloseReason.CloseCodes.NORMAL_CLOSURE.getCode()) {
            Http2InputMessageFrame http2InputMessage = new Http2InputMessageFrame((InputStream)StreamUtils.EMPTY, true);
            webSocketTransportListener.onData((HttpInputMessage)http2InputMessage);
            return;
        }
        webSocketTransportListener.cancelByRemote((long)closeReason.getCloseCode().getCode());
    }

    public void onError(Session session, Throwable thr) {
        super.onError(session, thr);
        WebSocketTransportListener webSocketTransportListener = (WebSocketTransportListener)session.getUserProperties().get("tri.websocket.listener");
        if (webSocketTransportListener == null) {
            return;
        }
        webSocketTransportListener.cancelByRemote((long)HttpStatus.INTERNAL_SERVER_ERROR.getCode());
    }
}

