/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.servlet.jakarta;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.rpc.protocol.tri.rest.RestException;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.ArgumentResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ParameterMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.support.servlet.jakarta.Helper;

@Activate(onClass={"jakarta.servlet.http.HttpServletRequest"})
public class ServletArgumentResolver
implements ArgumentResolver {
    private static final Set<Class<?>> SUPPORTED_TYPES = new HashSet();

    public boolean accept(ParameterMeta parameter) {
        return SUPPORTED_TYPES.contains(parameter.getActualType());
    }

    public Object resolve(ParameterMeta parameter, HttpRequest request, HttpResponse response) {
        Class type = parameter.getActualType();
        if (type == ServletRequest.class || type == HttpServletRequest.class) {
            return request;
        }
        if (type == ServletResponse.class || type == HttpServletResponse.class) {
            return response;
        }
        if (type == HttpSession.class) {
            return ((HttpServletRequest)request).getSession();
        }
        if (type == Cookie.class) {
            return Helper.convert(request.cookie(parameter.getRequiredName()));
        }
        if (type == Cookie[].class) {
            return ((HttpServletRequest)request).getCookies();
        }
        if (type == Reader.class) {
            try {
                return ((HttpServletRequest)request).getReader();
            }
            catch (IOException e) {
                throw new RestException((Throwable)e);
            }
        }
        if (type == Writer.class) {
            try {
                return ((HttpServletResponse)response).getWriter();
            }
            catch (IOException e) {
                throw new RestException((Throwable)e);
            }
        }
        return null;
    }

    static {
        SUPPORTED_TYPES.add(ServletRequest.class);
        SUPPORTED_TYPES.add(HttpServletRequest.class);
        SUPPORTED_TYPES.add(ServletResponse.class);
        SUPPORTED_TYPES.add(HttpServletResponse.class);
        SUPPORTED_TYPES.add(HttpSession.class);
        SUPPORTED_TYPES.add(Cookie.class);
        SUPPORTED_TYPES.add(Cookie[].class);
        SUPPORTED_TYPES.add(Reader.class);
        SUPPORTED_TYPES.add(Writer.class);
    }
}

