/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.servlet;

import javax.servlet.ServletContext;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.remoting.http12.HttpChannel;
import org.apache.dubbo.remoting.http12.HttpMetadata;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.remoting.http12.message.HttpMessageAdapterFactory;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.rest.filter.RestExtension;
import org.apache.dubbo.rpc.protocol.tri.rest.support.servlet.DummyFilterConfig;
import org.apache.dubbo.rpc.protocol.tri.rest.support.servlet.DummyServletContext;
import org.apache.dubbo.rpc.protocol.tri.rest.support.servlet.HttpSessionFactory;
import org.apache.dubbo.rpc.protocol.tri.rest.support.servlet.ServletHttpRequestAdapter;
import org.apache.dubbo.rpc.protocol.tri.rest.support.servlet.ServletHttpResponseAdapter;

@Activate(order=-100, onClass={"javax.servlet.http.HttpServletRequest"})
public final class ServletHttpMessageAdapterFactory
implements HttpMessageAdapterFactory<ServletHttpRequestAdapter, HttpMetadata, Void> {
    private final FrameworkModel frameworkModel;
    private final ServletContext servletContext;
    private final HttpSessionFactory httpSessionFactory;

    public ServletHttpMessageAdapterFactory(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
        this.servletContext = (ServletContext)this.createDummyServletContext(frameworkModel);
        this.httpSessionFactory = this.getHttpSessionFactory(frameworkModel);
    }

    private HttpSessionFactory getHttpSessionFactory(FrameworkModel frameworkModel) {
        for (RestExtension extension : frameworkModel.getActivateExtensions(RestExtension.class)) {
            if (!(extension instanceof HttpSessionFactory)) continue;
            return (HttpSessionFactory)extension;
        }
        return null;
    }

    public ServletHttpRequestAdapter adaptRequest(HttpMetadata rawRequest, HttpChannel channel) {
        return new ServletHttpRequestAdapter(rawRequest, channel, this.servletContext, this.httpSessionFactory);
    }

    public HttpResponse adaptResponse(ServletHttpRequestAdapter request, HttpMetadata rawRequest, Void rawResponse) {
        return new ServletHttpResponseAdapter();
    }

    public Object adaptFilterConfig(String filterName) {
        return new DummyFilterConfig(filterName, this.frameworkModel, this.servletContext);
    }

    private Object createDummyServletContext(FrameworkModel frameworkModel) {
        return new DummyServletContext(frameworkModel);
    }
}

