/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.servlet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.http.Cookie;
import javax.servlet.http.Part;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.remoting.http12.HttpCookie;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.rpc.protocol.tri.rest.support.servlet.FileUploadPart;

final class Helper {
    private Helper() {
    }

    static Cookie[] convertCookies(Collection<HttpCookie> hCookies) {
        Cookie[] cookies = new Cookie[hCookies.size()];
        int i = 0;
        for (HttpCookie cookie : hCookies) {
            cookies[i++] = Helper.convert(cookie);
        }
        return cookies;
    }

    static Cookie convert(HttpCookie hCookie) {
        Cookie cookie = new Cookie(hCookie.name(), hCookie.value());
        if (hCookie.domain() != null) {
            cookie.setDomain(hCookie.domain());
        }
        cookie.setMaxAge((int)hCookie.maxAge());
        cookie.setHttpOnly(hCookie.httpOnly());
        cookie.setPath(hCookie.path());
        cookie.setSecure(hCookie.secure());
        return cookie;
    }

    static HttpCookie convert(Cookie sCookie) {
        HttpCookie cookie = new HttpCookie(sCookie.getName(), sCookie.getValue());
        cookie.setDomain(sCookie.getDomain());
        cookie.setMaxAge((long)sCookie.getMaxAge());
        cookie.setHttpOnly(sCookie.isHttpOnly());
        cookie.setPath(sCookie.getPath());
        cookie.setSecure(sCookie.getSecure());
        return cookie;
    }

    public static FileUploadPart convert(HttpRequest.FileUpload part) {
        return new FileUploadPart(part);
    }

    public static Collection<Part> convertParts(Collection<HttpRequest.FileUpload> parts) {
        if (CollectionUtils.isEmpty(parts)) {
            return Collections.emptyList();
        }
        ArrayList<Part> result = new ArrayList<Part>(parts.size());
        for (HttpRequest.FileUpload part : parts) {
            result.add(Helper.convert(part));
        }
        return result;
    }
}

