/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.servlet;

import java.io.IOException;
import java.util.Arrays;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.remoting.http12.message.HttpMessageAdapterFactory;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.rest.RestException;
import org.apache.dubbo.rpc.protocol.tri.rest.filter.RestExtensionAdapter;
import org.apache.dubbo.rpc.protocol.tri.rest.filter.RestFilter;
import org.apache.dubbo.rpc.protocol.tri.rest.support.servlet.ServletHttpMessageAdapterFactory;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RestUtils;

@Activate(onClass={"javax.servlet.Filter"})
public final class FilterAdapter
implements RestExtensionAdapter<Filter> {
    private final ServletHttpMessageAdapterFactory adapterFactory;

    public FilterAdapter(FrameworkModel frameworkModel) {
        this.adapterFactory = (ServletHttpMessageAdapterFactory)frameworkModel.getExtension(HttpMessageAdapterFactory.class, "servlet");
    }

    public boolean accept(Object extension) {
        return extension instanceof Filter;
    }

    public RestFilter adapt(Filter extension) {
        try {
            String filterName = extension.getClass().getSimpleName();
            extension.init((FilterConfig)this.adapterFactory.adaptFilterConfig(filterName));
        }
        catch (ServletException e) {
            throw new RestException((Throwable)e);
        }
        return new FilterRestFilter(extension);
    }

    private static final class FilterRestFilter
    implements RestFilter {
        private final Filter filter;

        public int getPriority() {
            return RestUtils.getPriority((Object)this.filter);
        }

        public String[] getPatterns() {
            return RestUtils.getPattens((Object)this.filter);
        }

        public FilterRestFilter(Filter filter) {
            this.filter = filter;
        }

        public void doFilter(HttpRequest request, HttpResponse response, RestFilter.FilterChain chain) throws Exception {
            this.filter.doFilter((ServletRequest)request, (ServletResponse)response, (q, p) -> {
                try {
                    chain.doFilter(request, response);
                }
                catch (IOException | RuntimeException | ServletException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ServletException((Throwable)e);
                }
            });
        }

        public String toString() {
            Object[] patterns;
            StringBuilder sb = new StringBuilder("RestFilter{filter=");
            sb.append(this.filter);
            int priority = this.getPriority();
            if (priority != 0) {
                sb.append(", priority=").append(priority);
            }
            if ((patterns = this.getPatterns()) != null) {
                sb.append(", patterns=").append(Arrays.toString(patterns));
            }
            return sb.append('}').toString();
        }
    }
}

