/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.tracing.exporter.otlp;

import io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporter;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporterBuilder;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Map;
import org.apache.dubbo.config.nested.ExporterConfig;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class OTlpSpanExporter {
    public static SpanExporter getSpanExporter(ApplicationModel applicationModel, ExporterConfig.OtlpConfig otlpConfig) {
        OtlpGrpcSpanExporter externalOTlpGrpcSpanExporter = (OtlpGrpcSpanExporter)applicationModel.getBeanFactory().getBean(OtlpGrpcSpanExporter.class);
        if (externalOTlpGrpcSpanExporter != null) {
            return externalOTlpGrpcSpanExporter;
        }
        OtlpHttpSpanExporter externalOtlpHttpSpanExporter = (OtlpHttpSpanExporter)applicationModel.getBeanFactory().getBean(OtlpHttpSpanExporter.class);
        if (externalOtlpHttpSpanExporter != null) {
            return externalOtlpHttpSpanExporter;
        }
        OtlpGrpcSpanExporterBuilder builder = OtlpGrpcSpanExporter.builder().setEndpoint(otlpConfig.getEndpoint()).setTimeout(otlpConfig.getTimeout()).setCompression(otlpConfig.getCompressionMethod());
        for (Map.Entry entry : otlpConfig.getHeaders().entrySet()) {
            builder.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        return builder.build();
    }
}

