/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.tracing.handler;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationHandler;
import io.micrometer.observation.transport.ReceiverContext;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.Tracer;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.tracing.context.DubboServerContext;

public class DubboServerTracingObservationHandler<T extends DubboServerContext>
implements ObservationHandler<T> {
    private static final String DEFAULT_TRACE_ID_KEY = "traceId";
    private final Tracer tracer;

    public DubboServerTracingObservationHandler(Tracer tracer) {
        this.tracer = tracer;
    }

    public void onScopeOpened(T context) {
        TraceContext traceContext = this.tracer.currentTraceContext().context();
        if (traceContext == null) {
            return;
        }
        RpcContext.getServerContext().setAttachment(DEFAULT_TRACE_ID_KEY, traceContext.traceId());
    }

    public boolean supportsContext(Observation.Context context) {
        return context instanceof ReceiverContext;
    }
}

