/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.tracing.exporter.zipkin;

import io.opentelemetry.sdk.trace.export.SpanExporter;
import org.apache.dubbo.config.nested.ExporterConfig;
import org.apache.dubbo.rpc.model.ApplicationModel;
import zipkin2.Span;
import zipkin2.codec.BytesEncoder;
import zipkin2.codec.SpanBytesEncoder;

public class ZipkinSpanExporter {
    public static SpanExporter getSpanExporter(ApplicationModel applicationModel, ExporterConfig.ZipkinConfig zipkinConfig) {
        return io.opentelemetry.exporter.zipkin.ZipkinSpanExporter.builder().setEncoder(ZipkinSpanExporter.getSpanBytesEncoder(applicationModel)).setEndpoint(zipkinConfig.getEndpoint()).setReadTimeout(zipkinConfig.getReadTimeout()).build();
    }

    private static BytesEncoder<Span> getSpanBytesEncoder(ApplicationModel applicationModel) {
        BytesEncoder encoder = (BytesEncoder)applicationModel.getBeanFactory().getBean(BytesEncoder.class);
        return encoder == null ? SpanBytesEncoder.JSON_V2 : encoder;
    }
}

