/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.boot.context.event;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.spring.boot.util.DubboUtils;
import org.springframework.boot.context.event.ApplicationContextInitializedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.annotation.Order;

@Order(value=-2147483627)
public class WelcomeLogoApplicationListener
implements ApplicationListener<ApplicationContextInitializedEvent> {
    private static AtomicBoolean processed = new AtomicBoolean(false);

    public void onApplicationEvent(ApplicationContextInitializedEvent event) {
        if (processed.get()) {
            return;
        }
        Logger logger = LoggerFactory.getLogger(this.getClass());
        String bannerText = this.buildBannerText();
        if (logger.isInfoEnabled()) {
            logger.info(bannerText);
        }
        processed.compareAndSet(false, true);
    }

    String buildBannerText() {
        StringBuilder bannerTextBuilder = new StringBuilder();
        bannerTextBuilder.append(DubboUtils.LINE_SEPARATOR).append(DubboUtils.LINE_SEPARATOR).append(" :: Dubbo (v").append(Version.getVersion()).append(") : ").append("https://github.com/apache/dubbo").append(DubboUtils.LINE_SEPARATOR).append(" :: Discuss group : ").append("dev@dubbo.apache.org").append(DubboUtils.LINE_SEPARATOR);
        return bannerTextBuilder.toString();
    }
}

