/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.boot.interceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.dubbo.rpc.RpcContext;
import org.springframework.web.servlet.HandlerInterceptor;

public class DubboTagHeaderOrParameterInterceptor
implements HandlerInterceptor {
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String tag = request.getHeader("dubbo-tag");
        if (tag == null) {
            tag = request.getParameter("dubbo.tag");
        }
        if (tag != null) {
            RpcContext.getClientAttachment().setAttachment("dubbo.tag", tag);
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        RpcContext.getClientAttachment().removeAttachment("dubbo.tag");
    }
}

