/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.boot.autoconfigure.observability;

import io.micrometer.observation.ObservationHandler;
import io.micrometer.observation.ObservationRegistry;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.dubbo.spring.boot.autoconfigure.observability.ObservationHandlerGrouping;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class ObservationRegistryPostProcessor
implements BeanPostProcessor {
    private final ObjectProvider<ObservationHandlerGrouping> observationHandlerGrouping;
    private final ObjectProvider<ObservationHandler<?>> observationHandlers;

    public ObservationRegistryPostProcessor(ObjectProvider<ObservationHandlerGrouping> observationHandlerGrouping, ObjectProvider<ObservationHandler<?>> observationHandlers) {
        this.observationHandlerGrouping = observationHandlerGrouping;
        this.observationHandlers = observationHandlers;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof ObservationRegistry) {
            ObservationRegistry observationRegistry = (ObservationRegistry)bean;
            List observationHandlerList = this.observationHandlers.orderedStream().collect(Collectors.toList());
            this.observationHandlerGrouping.ifAvailable(grouping -> grouping.apply(observationHandlerList, observationRegistry.observationConfig()));
        }
        return bean;
    }
}

