/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.boot.autoconfigure;

import com.alibaba.spring.context.config.ConfigurationBeanBinder;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.config.spring.util.PropertySourcesUtils;
import org.apache.dubbo.spring.boot.autoconfigure.BinderDubboConfigBinder;
import org.apache.dubbo.spring.boot.autoconfigure.DubboRelaxedBindingAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(prefix="dubbo", name={"enabled"}, matchIfMissing=true)
@ConditionalOnClass(name={"org.springframework.boot.context.properties.bind.Binder"})
@AutoConfigureBefore(value={DubboRelaxedBindingAutoConfiguration.class})
public class DubboRelaxedBinding2AutoConfiguration {
    public PropertyResolver dubboScanBasePackagesPropertyResolver(final ConfigurableEnvironment environment) {
        AbstractEnvironment propertyResolver = new AbstractEnvironment(){

            protected void customizePropertySources(MutablePropertySources propertySources) {
                Map dubboScanProperties = PropertySourcesUtils.getSubProperties((PropertySources)environment.getPropertySources(), (String)"dubbo.scan.");
                propertySources.addLast((PropertySource)new MapPropertySource("dubboScanProperties", dubboScanProperties));
            }
        };
        ConfigurationPropertySources.attach((Environment)propertyResolver);
        return propertyResolver;
    }

    @ConditionalOnMissingBean(name={"dubbo-service-class-base-packages"})
    @Bean(name={"dubbo-service-class-base-packages"})
    public Set<String> dubboBasePackages(ConfigurableEnvironment environment) {
        PropertyResolver propertyResolver = this.dubboScanBasePackagesPropertyResolver(environment);
        return (Set)propertyResolver.getProperty("base-packages", Set.class, Collections.emptySet());
    }

    @ConditionalOnMissingBean(name={"relaxedDubboConfigBinder"}, value={ConfigurationBeanBinder.class})
    @Bean(value={"relaxedDubboConfigBinder"})
    @Scope(scopeName="prototype")
    public ConfigurationBeanBinder relaxedDubboConfigBinder() {
        return new BinderDubboConfigBinder();
    }
}

