/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.boot.autoconfigure;

import com.alibaba.spring.context.config.ConfigurationBeanBinder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.bind.PlaceholdersResolver;
import org.springframework.boot.context.properties.bind.PropertySourcesPlaceholdersResolver;
import org.springframework.boot.context.properties.bind.handler.IgnoreErrorsBindHandler;
import org.springframework.boot.context.properties.bind.handler.NoUnboundElementsBindHandler;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.boot.context.properties.source.UnboundElementsSourceFilter;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

class BinderDubboConfigBinder
implements ConfigurationBeanBinder {
    BinderDubboConfigBinder() {
    }

    public void bind(Map<String, Object> configurationProperties, boolean ignoreUnknownFields, boolean ignoreInvalidFields, Object configurationBean) {
        List<PropertySource> propertySources = Arrays.asList(new MapPropertySource("internal", configurationProperties));
        Iterable configurationPropertySources = ConfigurationPropertySources.from(propertySources);
        Bindable bindable = Bindable.ofInstance((Object)configurationBean);
        Binder binder = new Binder(configurationPropertySources, (PlaceholdersResolver)new PropertySourcesPlaceholdersResolver(propertySources));
        BindHandler bindHandler = this.getBindHandler(ignoreUnknownFields, ignoreInvalidFields);
        binder.bind("", bindable, bindHandler);
    }

    private BindHandler getBindHandler(boolean ignoreUnknownFields, boolean ignoreInvalidFields) {
        BindHandler handler = BindHandler.DEFAULT;
        if (ignoreInvalidFields) {
            handler = new IgnoreErrorsBindHandler(handler);
        }
        if (!ignoreUnknownFields) {
            UnboundElementsSourceFilter filter = new UnboundElementsSourceFilter();
            handler = new NoUnboundElementsBindHandler(handler, (Function)filter);
        }
        return handler;
    }
}

