/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.hessian2.aot;

import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.apache.dubbo.aot.api.MemberCategory;
import org.apache.dubbo.aot.api.ReflectionTypeDescriberRegistrar;
import org.apache.dubbo.aot.api.TypeDescriber;

public class HessianReflectionTypeDescriberRegistrar
implements ReflectionTypeDescriberRegistrar {
    public List<TypeDescriber> getTypeDescribers() {
        ArrayList<TypeDescriber> typeDescribers = new ArrayList<TypeDescriber>();
        this.loadFile("META-INF/dubbo/hessian/deserializers", typeDescribers);
        this.loadFile("META-INF/dubbo/hessian/serializers", typeDescribers);
        typeDescribers.add(this.buildTypeDescriberWithDeclared(Date.class));
        typeDescribers.add(this.buildTypeDescriberWithDeclared(Time.class));
        typeDescribers.add(this.buildTypeDescriberWithDeclared(Timestamp.class));
        return typeDescribers;
    }

    private void loadFile(String path, List<TypeDescriber> typeDescribers) {
        try {
            Enumeration<URL> resources = this.getClass().getClassLoader().getResources(path);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                Properties props = new Properties();
                props.load(url.openStream());
                for (Object value : props.values()) {
                    String className = (String)value;
                    typeDescribers.add(this.buildTypeDescriberWithDeclared(className));
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private TypeDescriber buildTypeDescriberWithDeclared(Class<?> cl) {
        HashSet<MemberCategory> memberCategories = new HashSet<MemberCategory>();
        memberCategories.add(MemberCategory.INVOKE_DECLARED_METHODS);
        memberCategories.add(MemberCategory.INVOKE_DECLARED_CONSTRUCTORS);
        memberCategories.add(MemberCategory.DECLARED_FIELDS);
        return new TypeDescriber(cl.getName(), null, new HashSet(), new HashSet(), new HashSet(), memberCategories);
    }

    private TypeDescriber buildTypeDescriberWithDeclared(String cl) {
        HashSet<MemberCategory> memberCategories = new HashSet<MemberCategory>();
        memberCategories.add(MemberCategory.INVOKE_DECLARED_METHODS);
        memberCategories.add(MemberCategory.INVOKE_DECLARED_CONSTRUCTORS);
        memberCategories.add(MemberCategory.DECLARED_FIELDS);
        return new TypeDescriber(cl, null, new HashSet(), new HashSet(), new HashSet(), memberCategories);
    }
}

