/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.security.cert;

import org.apache.dubbo.common.beans.factory.ScopeBeanFactory;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ScopeModelInitializer;
import org.apache.dubbo.security.cert.DubboCertManager;

public class CertScopeModelInitializer
implements ScopeModelInitializer {
    public static boolean isSupported() {
        try {
            ClassUtils.forName((String)"io.grpc.Channel");
            ClassUtils.forName((String)"org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder");
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public void initializeFrameworkModel(FrameworkModel frameworkModel) {
        ScopeBeanFactory beanFactory = frameworkModel.getBeanFactory();
        if (CertScopeModelInitializer.isSupported()) {
            beanFactory.registerBean(DubboCertManager.class);
        }
    }

    public void initializeApplicationModel(ApplicationModel applicationModel) {
    }

    public void initializeModuleModel(ModuleModel moduleModel) {
    }
}

