/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.websocket;

import java.util.concurrent.Executor;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.remoting.http12.HttpHeaders;
import org.apache.dubbo.remoting.http12.h2.H2StreamChannel;
import org.apache.dubbo.remoting.http12.h2.Http2Header;
import org.apache.dubbo.remoting.http12.h2.Http2InputMessage;
import org.apache.dubbo.remoting.http12.h2.Http2ServerChannelObserver;
import org.apache.dubbo.remoting.http12.message.StreamingDecoder;
import org.apache.dubbo.remoting.websocket.FinalFragmentStreamingDecoder;
import org.apache.dubbo.remoting.websocket.WebSocketHeaderNames;
import org.apache.dubbo.remoting.websocket.WebSocketTransportListener;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.protocol.tri.h12.http2.GenericHttp2ServerTransportListener;
import org.apache.dubbo.rpc.protocol.tri.websocket.WebSocketServerChannelObserver;

public class DefaultWebSocketServerTransportListener
extends GenericHttp2ServerTransportListener
implements WebSocketTransportListener {
    private boolean autoClose = false;

    public DefaultWebSocketServerTransportListener(H2StreamChannel h2StreamChannel, URL url, FrameworkModel frameworkModel) {
        super(h2StreamChannel, url, frameworkModel);
    }

    @Override
    protected void onBeforeMetadata(Http2Header metadata) {
    }

    @Override
    protected Executor initializeExecutor(URL url, Http2Header metadata) {
        return this.getExecutor(url, metadata);
    }

    @Override
    protected void onPrepareMetadata(Http2Header metadata) {
        this.doRoute(metadata);
    }

    @Override
    protected StreamingDecoder newStreamingDecoder() {
        return new FinalFragmentStreamingDecoder();
    }

    @Override
    protected Http2ServerChannelObserver newResponseObserver(H2StreamChannel h2StreamChannel) {
        return new WebSocketServerChannelObserver(this.getFrameworkModel(), h2StreamChannel);
    }

    @Override
    protected Http2ServerChannelObserver newStreamResponseObserver(H2StreamChannel h2StreamChannel) {
        return new WebSocketServerChannelObserver(this.getFrameworkModel(), h2StreamChannel);
    }

    @Override
    protected Http2ServerChannelObserver prepareResponseObserver(Http2ServerChannelObserver responseObserver) {
        responseObserver.addTrailersCustomizer(this::customizeWebSocketStatus);
        return super.prepareResponseObserver(responseObserver);
    }

    @Override
    protected void prepareUnaryServerCall() {
        this.autoClose = true;
        super.prepareUnaryServerCall();
    }

    @Override
    protected void prepareStreamServerCall() {
        if (this.getContext().getMethodDescriptor().getRpcType().equals((Object)MethodDescriptor.RpcType.SERVER_STREAM)) {
            this.autoClose = true;
        }
        super.prepareStreamServerCall();
    }

    @Override
    protected void onDataCompletion(Http2InputMessage message) {
        if (this.autoClose) {
            this.getStreamingDecoder().close();
            return;
        }
        super.onDataCompletion(message);
    }

    private void customizeWebSocketStatus(HttpHeaders httpHeaders, Throwable throwable) {
        if (throwable != null) {
            httpHeaders.set((CharSequence)WebSocketHeaderNames.WEBSOCKET_MESSAGE.getName(), throwable.getMessage());
        }
    }
}

