/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.dubbo.common.utils.AnnotationUtils;
import org.apache.dubbo.common.utils.DefaultParameterNameReader;
import org.apache.dubbo.common.utils.ParameterNameReader;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.rest.Messages;
import org.apache.dubbo.rpc.protocol.tri.rest.RestException;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.CompositeArgumentResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.GeneralTypeConverter;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.TypeConverter;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.NamedValueMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ParameterMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RestToolKit;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RestUtils;

public abstract class AbstractRestToolKit
implements RestToolKit {
    protected final FrameworkModel frameworkModel;
    protected final TypeConverter typeConverter;
    protected final ParameterNameReader parameterNameReader;
    protected final CompositeArgumentResolver argumentResolver;

    public AbstractRestToolKit(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
        this.typeConverter = (TypeConverter)frameworkModel.getOrRegisterBean(GeneralTypeConverter.class);
        this.parameterNameReader = (ParameterNameReader)frameworkModel.getOrRegisterBean(DefaultParameterNameReader.class);
        this.argumentResolver = (CompositeArgumentResolver)frameworkModel.getOrRegisterBean(CompositeArgumentResolver.class);
    }

    @Override
    public String resolvePlaceholders(String text) {
        return RestUtils.replacePlaceholder(text, k -> this.frameworkModel.defaultApplication().modelEnvironment().getConfiguration().getString(k));
    }

    @Override
    public Object convert(Object value, ParameterMeta parameter) {
        Object target = this.typeConverter.convert(value, parameter.getGenericType());
        if (target == null && value != null) {
            throw new RestException(Messages.ARGUMENT_CONVERT_ERROR, parameter.getName(), value, value.getClass(), parameter.getGenericType());
        }
        return target;
    }

    @Override
    public NamedValueMeta getNamedValueMeta(ParameterMeta parameter) {
        return this.argumentResolver.getNamedValueMeta(parameter);
    }

    @Override
    public String[] getParameterNames(Method method) {
        return this.parameterNameReader.readParameterNames(method);
    }

    @Override
    @Nullable
    public String[] getParameterNames(Constructor<?> ctor) {
        return this.parameterNameReader.readParameterNames(ctor);
    }

    @Override
    public Map<String, Object> getAttributes(AnnotatedElement element, Annotation annotation) {
        return AnnotationUtils.getAttributes((Annotation)annotation, (boolean)false);
    }
}

