/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta;

import java.lang.reflect.Type;
import java.util.Arrays;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.http12.rest.ParamType;
import org.apache.dubbo.rpc.protocol.tri.rest.Messages;
import org.apache.dubbo.rpc.protocol.tri.rest.RestException;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ParameterMeta;

public class NamedValueMeta {
    public static final NamedValueMeta EMPTY = new NamedValueMeta();
    private String name;
    private final boolean required;
    private final String defaultValue;
    private ParamType paramType;
    private Class<?> type;
    private Type genericType;
    private Class<?>[] nestedTypes;
    private ParameterMeta parameter;

    public NamedValueMeta(String name, boolean required, String defaultValue) {
        this.name = name;
        this.required = required;
        this.defaultValue = defaultValue;
    }

    public NamedValueMeta(String name, boolean required) {
        this.name = name;
        this.required = required;
        this.defaultValue = null;
    }

    public NamedValueMeta() {
        this.required = false;
        this.defaultValue = null;
    }

    public String name() {
        if (this.name == null) {
            throw new RestException(Messages.ARGUMENT_NAME_MISSING, this.type);
        }
        return this.name;
    }

    public NamedValueMeta setName(String name) {
        this.name = name;
        return this;
    }

    public boolean isNameEmpty() {
        return StringUtils.isEmpty((String)this.name);
    }

    public boolean required() {
        return this.required;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    public ParamType paramType() {
        return this.paramType;
    }

    public NamedValueMeta setParamType(ParamType paramType) {
        this.paramType = paramType;
        return this;
    }

    public Class<?> type() {
        return this.type;
    }

    public NamedValueMeta setType(Class<?> type) {
        this.type = type;
        return this;
    }

    public Type genericType() {
        return this.genericType;
    }

    public NamedValueMeta setGenericType(Type genericType) {
        this.genericType = genericType;
        return this;
    }

    public Class<?>[] nestedTypes() {
        return this.nestedTypes;
    }

    public NamedValueMeta setNestedTypes(Class<?>[] nestedTypes) {
        this.nestedTypes = nestedTypes;
        return this;
    }

    public Class<?> nestedType() {
        return this.nestedTypes == null ? null : this.nestedTypes[0];
    }

    public Class<?> nestedType(int index) {
        return this.nestedTypes == null || this.nestedTypes.length <= index ? null : this.nestedTypes[index];
    }

    public ParameterMeta parameter() {
        return this.parameter;
    }

    public NamedValueMeta setParameter(ParameterMeta parameter) {
        this.parameter = parameter;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("NamedValueMeta{name='");
        sb.append(this.name).append('\'');
        if (this.required) {
            sb.append(", required=true");
        }
        if (this.defaultValue != null) {
            sb.append(", defaultValue='").append(this.defaultValue).append('\'');
        }
        if (this.paramType != null) {
            sb.append(", paramType=").append(this.paramType);
        }
        if (this.type != null) {
            sb.append(", type=").append(this.type);
            if (this.genericType != this.type) {
                sb.append(", genericType=").append(this.genericType);
            }
        }
        if (this.nestedTypes != null) {
            sb.append(", nestedTypes=").append(Arrays.toString(this.nestedTypes));
        }
        sb.append('}');
        return sb.toString();
    }
}

