/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.MethodMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ParameterMeta;

public final class MethodParameterMeta
extends ParameterMeta {
    private final List<Parameter> hierarchy;
    private final Parameter parameter;
    private final int index;
    private final MethodMeta methodMeta;

    public MethodParameterMeta(List<Parameter> hierarchy, String name, int index, MethodMeta methodMeta) {
        super(methodMeta.getToolKit(), name);
        this.hierarchy = hierarchy;
        this.parameter = hierarchy.get(0);
        this.index = index;
        this.methodMeta = methodMeta;
    }

    public List<Parameter> getHierarchy() {
        return this.hierarchy;
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public MethodMeta getMethodMeta() {
        return this.methodMeta;
    }

    @Override
    public Class<?> getType() {
        return this.parameter.getType();
    }

    @Override
    public Type getGenericType() {
        return this.parameter.getParameterizedType();
    }

    @Override
    public String getDescription() {
        return "parameter [" + this.getMethod() + "] in {" + this.index + "}";
    }

    public Method getMethod() {
        return this.methodMeta.getMethod();
    }

    @Override
    protected AnnotatedElement getAnnotatedElement() {
        return this.parameter;
    }

    @Override
    public List<? extends AnnotatedElement> getAnnotatedElements() {
        return this.hierarchy;
    }

    public int hashCode() {
        return 31 * this.getMethod().hashCode() + this.index;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != MethodParameterMeta.class) {
            return false;
        }
        MethodParameterMeta other = (MethodParameterMeta)obj;
        return this.getMethod().equals(other.getMethod()) && this.index == other.index;
    }

    @Override
    public String toString() {
        return "MethodParameterMeta{parameter=" + this.parameter + '}';
    }
}

