/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition;

import java.util.Objects;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.rpc.protocol.tri.TripleHeaderEnum;
import org.apache.dubbo.rpc.protocol.tri.TripleProtocol;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.Condition;

public final class ServiceGroupVersionCondition
implements Condition<ServiceGroupVersionCondition, HttpRequest> {
    private final String group;
    private final String version;

    public ServiceGroupVersionCondition(String group, String version) {
        this.group = group;
        this.version = version;
    }

    @Override
    public ServiceGroupVersionCondition combine(ServiceGroupVersionCondition other) {
        return this;
    }

    @Override
    public ServiceGroupVersionCondition match(HttpRequest request) {
        if (TripleProtocol.RESOLVE_FALLBACK_TO_DEFAULT) {
            return this;
        }
        String group = ServiceGroupVersionCondition.getHeader(request, TripleHeaderEnum.SERVICE_GROUP, "rest-service-group");
        if (!Objects.equals(group, this.group)) {
            return null;
        }
        String version = ServiceGroupVersionCondition.getHeader(request, TripleHeaderEnum.SERVICE_VERSION, "rest-service-version");
        if (!Objects.equals(version, this.version)) {
            return null;
        }
        return this;
    }

    @Override
    public int compareTo(ServiceGroupVersionCondition other, HttpRequest request) {
        if (!TripleProtocol.RESOLVE_FALLBACK_TO_DEFAULT) {
            return 0;
        }
        String group = ServiceGroupVersionCondition.getHeader(request, TripleHeaderEnum.SERVICE_GROUP, "rest-service-group");
        String version = ServiceGroupVersionCondition.getHeader(request, TripleHeaderEnum.SERVICE_VERSION, "rest-service-version");
        return ServiceGroupVersionCondition.getMatchLevel(other, group, version) - ServiceGroupVersionCondition.getMatchLevel(this, group, version);
    }

    private static String getHeader(HttpRequest request, TripleHeaderEnum en, String key) {
        String value = request.header(en.getKey());
        if (value == null) {
            value = request.header((CharSequence)key);
        }
        return value;
    }

    private static int getMatchLevel(ServiceGroupVersionCondition condition, String group, String version) {
        if (Objects.equals(group, condition.group)) {
            if (Objects.equals(version, condition.version)) {
                return 9;
            }
            if (Objects.equals("1.0.0", condition.version)) {
                return 8;
            }
            return group == null ? 5 : 7;
        }
        if (Objects.equals(version, condition.version)) {
            return 6;
        }
        if (Objects.equals("1.0.0", condition.version)) {
            return 4;
        }
        return 3;
    }

    public int hashCode() {
        return Objects.hash(this.group, this.version);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != ServiceGroupVersionCondition.class) {
            return false;
        }
        ServiceGroupVersionCondition other = (ServiceGroupVersionCondition)obj;
        return Objects.equals(this.group, other.group) && Objects.equals(this.version, other.version);
    }

    public String toString() {
        return "ServiceVersionCondition{group='" + this.group + "', version='" + this.version + "'}";
    }
}

