/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.dubbo.common.utils.ArrayUtils;
import org.apache.dubbo.common.utils.CollectionUtils;

public final class NameValueExpression {
    private final String name;
    private final String value;
    private final boolean negated;

    private NameValueExpression(String name, String value, boolean negated) {
        this.name = name;
        this.value = value;
        this.negated = negated;
    }

    public NameValueExpression(String name, String value) {
        this.name = name;
        this.value = value;
        this.negated = false;
    }

    public static Set<NameValueExpression> parse(String ... params) {
        if (ArrayUtils.isEmpty((Object[])params)) {
            return Collections.emptySet();
        }
        int len = params.length;
        Set expressions = CollectionUtils.newHashSet((int)len);
        for (String param : params) {
            expressions.add(NameValueExpression.parse(param));
        }
        return expressions;
    }

    public static NameValueExpression parse(String expr) {
        int index = expr.indexOf(61);
        if (index == -1) {
            boolean negated = expr.indexOf(33) == 0;
            return new NameValueExpression(negated ? expr.substring(1) : expr, null, negated);
        }
        boolean negated = index > 0 && expr.charAt(index - 1) == '!';
        return new NameValueExpression(negated ? expr.substring(0, index - 1) : expr.substring(0, index), expr.substring(index + 1), negated);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public boolean match(Predicate<String> nameFn, Function<String, String> valueFn) {
        boolean matched = this.value == null ? nameFn.test(this.name) : Objects.equals(valueFn.apply(this.name), this.value);
        return matched != this.negated;
    }

    public boolean match(Function<String, String> valueFn) {
        return this.match(n -> valueFn.apply((String)n) != null, valueFn);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value, this.negated);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != NameValueExpression.class) {
            return false;
        }
        NameValueExpression other = (NameValueExpression)obj;
        return this.negated == other.negated && Objects.equals(this.name, other.name) && Objects.equals(this.value, other.value);
    }

    public String toString() {
        return this.name + (this.negated ? "!=" : "=") + this.value;
    }
}

