/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.compressor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.protocol.tri.compressor.Compressor;
import org.apache.dubbo.rpc.protocol.tri.compressor.DeCompressor;

public class Bzip2
implements Compressor,
DeCompressor {
    public static final String BZIP2 = "bzip2";

    @Override
    public String getMessageEncoding() {
        return BZIP2;
    }

    @Override
    public byte[] compress(byte[] payloadByteArr) throws RpcException {
        if (null == payloadByteArr || 0 == payloadByteArr.length) {
            return new byte[0];
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            BZip2CompressorOutputStream cos = new BZip2CompressorOutputStream((OutputStream)out);
            cos.write(payloadByteArr);
            cos.close();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return out.toByteArray();
    }

    @Override
    public OutputStream decorate(OutputStream outputStream) {
        try {
            return new BZip2CompressorOutputStream(outputStream);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public byte[] decompress(byte[] payloadByteArr) {
        if (null == payloadByteArr || 0 == payloadByteArr.length) {
            return new byte[0];
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = new ByteArrayInputStream(payloadByteArr);
        try {
            int n;
            BZip2CompressorInputStream unZip = new BZip2CompressorInputStream((InputStream)in);
            byte[] buffer = new byte[2048];
            while ((n = unZip.read(buffer)) >= 0) {
                out.write(buffer, 0, n);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return out.toByteArray();
    }
}

