/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.mapping;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.FluentLogger;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.config.context.ConfigManager;
import org.apache.dubbo.config.nested.RestConfig;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.exception.HttpStatusException;
import org.apache.dubbo.remoting.http12.message.MethodMetadata;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.model.ReflectionMethodDescriptor;
import org.apache.dubbo.rpc.model.ReflectionServiceDescriptor;
import org.apache.dubbo.rpc.model.ServiceDescriptor;
import org.apache.dubbo.rpc.protocol.tri.DescriptorUtils;
import org.apache.dubbo.rpc.protocol.tri.rest.Messages;
import org.apache.dubbo.rpc.protocol.tri.rest.RestConstants;
import org.apache.dubbo.rpc.protocol.tri.rest.RestMappingException;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.ContentNegotiator;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.RadixTree;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.RequestMapping;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.RequestMappingRegistry;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.RequestMappingResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.PathExpression;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.ProducesCondition;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.HandlerMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.MethodMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ServiceMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.util.KeyString;
import org.apache.dubbo.rpc.protocol.tri.rest.util.MethodWalker;
import org.apache.dubbo.rpc.protocol.tri.rest.util.PathUtils;

public final class DefaultRequestMappingRegistry
implements RequestMappingRegistry {
    private static final FluentLogger LOGGER = FluentLogger.of(DefaultRequestMappingRegistry.class);
    private final FrameworkModel frameworkModel;
    private final ContentNegotiator contentNegotiator;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final AtomicBoolean initialized = new AtomicBoolean();
    private RestConfig restConfig;
    private List<RequestMappingResolver> resolvers;
    private RadixTree<Registration> tree;

    public DefaultRequestMappingRegistry(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
        this.contentNegotiator = (ContentNegotiator)frameworkModel.getBeanFactory().getOrRegisterBean(ContentNegotiator.class);
    }

    private void init(Invoker<?> invoker) {
        this.restConfig = ConfigManager.getProtocolOrDefault((URL)invoker.getUrl()).getTripleOrDefault().getRestOrDefault();
        this.resolvers = this.frameworkModel.getActivateExtensions(RequestMappingResolver.class);
        this.tree = new RadixTree(this.restConfig.getCaseSensitiveMatchOrDefault());
    }

    @Override
    public void register(Invoker<?> invoker) {
        if (this.tree == null) {
            this.lock.writeLock().lock();
            try {
                if (this.initialized.compareAndSet(false, true)) {
                    this.init(invoker);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        URL url = invoker.getUrl();
        Object service = url.getServiceModel().getProxyObject();
        ServiceDescriptor sd = DescriptorUtils.getReflectionServiceDescriptor(url);
        if (sd == null) {
            return;
        }
        AtomicInteger counter = new AtomicInteger();
        long start = System.currentTimeMillis();
        new MethodWalker().walk(service.getClass(), (classes, consumer) -> {
            int size = this.resolvers.size();
            for (int i = 0; i < size; ++i) {
                RequestMappingResolver resolver = this.resolvers.get(i);
                ServiceMeta serviceMeta = new ServiceMeta((Collection<Class<?>>)classes, sd, service, url, resolver.getRestToolKit());
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("{} resolving rest mappings for {} at url [{}]", new Object[]{resolver.getClass().getSimpleName(), serviceMeta, url.toString(new String[]{""})});
                }
                if (!resolver.accept(serviceMeta)) continue;
                RequestMapping classMapping = resolver.resolve(serviceMeta);
                consumer.accept(methods -> {
                    Method method = (Method)methods.get(0);
                    MethodDescriptor md = sd.getMethod(method.getName(), (Class[])method.getParameterTypes());
                    MethodMeta methodMeta = new MethodMeta((List<Method>)methods, md, serviceMeta);
                    if (!resolver.accept(methodMeta)) {
                        return;
                    }
                    RequestMapping methodMapping = resolver.resolve(methodMeta);
                    if (methodMapping == null) {
                        return;
                    }
                    if (md == null) {
                        if (!(sd instanceof ReflectionServiceDescriptor)) {
                            return;
                        }
                        md = new ReflectionMethodDescriptor(method);
                        ((ReflectionServiceDescriptor)sd).addMethod(md);
                        methodMeta.setMethodDescriptor(md);
                    }
                    if (classMapping != null) {
                        methodMapping = classMapping.combine(methodMapping);
                    }
                    methodMeta.initParameters();
                    MethodMetadata methodMetadata = MethodMetadata.fromMethodDescriptor((MethodDescriptor)md);
                    this.register0(methodMapping, new HandlerMeta(invoker, methodMeta, methodMetadata, md, sd), counter);
                });
            }
        });
        LOGGER.info("Registered {} rest mappings for service [{}] at url [{}] in {}ms", new Object[]{counter, ClassUtils.toShortString((Object)service), url.toString(new String[]{""}), System.currentTimeMillis() - start});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register0(RequestMapping mapping, HandlerMeta handler, AtomicInteger counter) {
        this.lock.writeLock().lock();
        try {
            Registration registration = new Registration();
            registration.mapping = mapping;
            registration.meta = handler;
            for (PathExpression path : mapping.getPathCondition().getExpressions()) {
                Registration exists = this.tree.addPath(path, registration);
                if (exists == null) {
                    if (LOGGER.isDebugEnabled()) {
                        String msg = "Register rest mapping: '{}' -> mapping={}, method={}";
                        LOGGER.debug(msg, new Object[]{path, mapping, handler.getMethod()});
                    }
                    counter.incrementAndGet();
                    continue;
                }
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.internalWarn(Messages.DUPLICATE_MAPPING.format(path, mapping, handler.getMethod(), exists));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void unregister(Invoker<?> invoker) {
        if (this.tree == null) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            this.tree.remove(mapping -> mapping.meta.getInvoker() == invoker);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void destroy() {
        if (this.tree == null) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            this.tree.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public HandlerMeta lookup(HttpRequest request) {
        ProducesCondition producesCondition;
        int size;
        String stringPath = PathUtils.normalize(request.uri());
        request.setAttribute("org.springframework.web.util.UrlPathHelper.PATH", (Object)stringPath);
        KeyString path = new KeyString(stringPath, this.restConfig.getCaseSensitiveMatchOrDefault());
        ArrayList<Candidate> candidates = new ArrayList<Candidate>();
        LinkedList<RequestMapping> partialMatches = new LinkedList<RequestMapping>();
        this.tryMatch(request, path, candidates, partialMatches);
        if (candidates.isEmpty()) {
            int end = path.length();
            if (this.restConfig.getTrailingSlashMatchOrDefault() && path.charAt(end - 1) == '/') {
                this.tryMatch(request, path.subSequence(0, --end), candidates, partialMatches);
            }
            if (candidates.isEmpty()) {
                char ch;
                for (int i = end - 1; i >= 0 && (ch = path.charAt(i)) != '/'; --i) {
                    if (ch == '.' && this.restConfig.getSuffixPatternMatchOrDefault() && this.contentNegotiator.supportExtension(path.toString(i + 1, end))) {
                        this.tryMatch(request, path.subSequence(0, i), candidates, partialMatches);
                        if (!candidates.isEmpty()) break;
                        end = i;
                    }
                    if (ch != '~') continue;
                    request.setAttribute(RestConstants.SIG_ATTRIBUTE, (Object)path.toString(i + 1, end));
                    this.tryMatch(request, path.subSequence(0, i), candidates, partialMatches);
                    if (!candidates.isEmpty()) break;
                }
            }
        }
        if ((size = candidates.size()) == 0) {
            this.handleNoMatch(request, partialMatches);
            return null;
        }
        if (size > 1) {
            candidates.sort((c1, c2) -> {
                int comparison = c1.expression.compareTo(c2.expression, stringPath);
                if (comparison != 0) {
                    return comparison;
                }
                comparison = c1.mapping.compareTo(c2.mapping, request);
                if (comparison != 0) {
                    return comparison;
                }
                return c1.variableMap.size() - c2.variableMap.size();
            });
            LOGGER.debug("Candidate rest mappings: {}", new Object[]{candidates});
            Candidate first = (Candidate)candidates.get(0);
            Candidate second = (Candidate)candidates.get(1);
            if (first.mapping.compareTo(second.mapping, request) == 0) {
                throw new RestMappingException(Messages.AMBIGUOUS_MAPPING, path, first, second);
            }
        }
        Candidate winner = (Candidate)candidates.get(0);
        RequestMapping mapping = winner.mapping;
        HandlerMeta handler = winner.meta;
        request.setAttribute(RestConstants.MAPPING_ATTRIBUTE, (Object)mapping);
        request.setAttribute(RestConstants.HANDLER_ATTRIBUTE, (Object)handler);
        LOGGER.debug("Matched rest mapping={}, method={}", new Object[]{mapping, handler.getMethod()});
        if (!winner.variableMap.isEmpty()) {
            request.setAttribute("org.springframework.web.servlet.HandlerMapping.uriTemplateVariables", winner.variableMap);
        }
        if ((producesCondition = mapping.getProducesCondition()) != null) {
            request.setAttribute("org.springframework.web.servlet.HandlerMapping.producibleMediaTypes", producesCondition.getMediaTypes());
        }
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryMatch(HttpRequest request, KeyString path, List<Candidate> candidates, List<RequestMapping> partialMatches) {
        int i;
        ArrayList matches = new ArrayList();
        this.lock.readLock().lock();
        try {
            this.tree.match(path, matches);
        }
        finally {
            this.lock.readLock().unlock();
        }
        int size = matches.size();
        if (size == 0) {
            return;
        }
        for (i = 0; i < size; ++i) {
            RadixTree.Match match = (RadixTree.Match)matches.get(i);
            RequestMapping mapping = ((Registration)match.getValue()).mapping.match(request, match.getExpression());
            if (mapping == null) continue;
            Candidate candidate = new Candidate();
            candidate.mapping = mapping;
            candidate.meta = ((Registration)match.getValue()).meta;
            candidate.expression = match.getExpression();
            candidate.variableMap = match.getVariableMap();
            candidates.add(candidate);
        }
        if (candidates.isEmpty()) {
            for (i = 0; i < size; ++i) {
                partialMatches.add(((Registration)((RadixTree.Match)matches.get((int)i)).getValue()).mapping);
            }
        }
    }

    private void handleNoMatch(HttpRequest request, List<RequestMapping> partialMatches) {
        if (partialMatches.isEmpty()) {
            return;
        }
        boolean methodsMismatch = true;
        boolean consumesMismatch = true;
        boolean producesMismatch = true;
        boolean paramsMismatch = true;
        for (RequestMapping mapping : partialMatches) {
            if (methodsMismatch) {
                boolean bl = methodsMismatch = !mapping.matchMethod(request.method());
            }
            if (consumesMismatch) {
                boolean bl = consumesMismatch = !mapping.matchConsumes(request);
            }
            if (producesMismatch) {
                boolean bl = producesMismatch = !mapping.matchProduces(request);
            }
            if (!paramsMismatch) continue;
            paramsMismatch = !mapping.matchParams(request);
        }
        if (methodsMismatch) {
            throw new HttpStatusException(405, "Request method '" + request.method() + "' not supported");
        }
        if (consumesMismatch) {
            throw new HttpStatusException(415, "Content type '" + request.contentType() + "' not supported");
        }
        if (producesMismatch) {
            throw new HttpStatusException(406, "Could not find acceptable representation");
        }
        if (paramsMismatch) {
            throw new HttpStatusException(400, "Unsatisfied query parameter conditions");
        }
    }

    @Override
    public boolean exists(String stringPath, String method) {
        char ch;
        KeyString path = new KeyString(stringPath, this.restConfig.getCaseSensitiveMatchOrDefault());
        if (this.tryExists(path, method)) {
            return true;
        }
        int end = path.length();
        if (this.restConfig.getTrailingSlashMatchOrDefault() && path.charAt(end - 1) == '/' && this.tryExists(path.subSequence(0, --end - 1), method)) {
            return true;
        }
        for (int i = end - 1; i >= 0 && (ch = path.charAt(i)) != '/'; --i) {
            if (ch == '.' && this.restConfig.getSuffixPatternMatchOrDefault() && this.contentNegotiator.supportExtension(path.toString(i + 1, end))) {
                if (this.tryExists(path.subSequence(0, i), method)) {
                    return true;
                }
                end = i;
            }
            if (ch != '~') continue;
            return this.tryExists(path.subSequence(0, i), method);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryExists(KeyString path, String method) {
        ArrayList matches = new ArrayList();
        this.lock.readLock().lock();
        try {
            this.tree.match(path, matches);
        }
        finally {
            this.lock.readLock().unlock();
        }
        int size = matches.size();
        for (int i = 0; i < size; ++i) {
            if (!((Registration)((RadixTree.Match)matches.get((int)i)).getValue()).mapping.matchMethod(method)) continue;
            return true;
        }
        return false;
    }

    private static final class Registration {
        RequestMapping mapping;
        HandlerMeta meta;

        private Registration() {
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != Registration.class) {
                return false;
            }
            return this.mapping.equals(((Registration)obj).mapping);
        }

        public int hashCode() {
            return this.mapping.hashCode();
        }

        public String toString() {
            return "Registration{mapping=" + this.mapping + ", method=" + this.meta.getMethod() + '}';
        }
    }

    private static final class Candidate {
        RequestMapping mapping;
        HandlerMeta meta;
        PathExpression expression;
        Map<String, String> variableMap;

        private Candidate() {
        }

        public String toString() {
            return "Candidate{mapping=" + this.mapping + ", method=" + this.meta.getMethod() + '}';
        }
    }
}

