/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.argument;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.rest.Messages;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.AnnotationBaseArgumentResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.ArgumentConverter;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.ArgumentResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.CompositeArgumentConverter;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.AnnotationMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ParameterMeta;

public final class CompositeArgumentResolver
implements ArgumentResolver {
    private final Map<Class, AnnotationBaseArgumentResolver> resolverMap = new HashMap<Class, AnnotationBaseArgumentResolver>();
    private final ArgumentResolver[] resolvers;
    private final ArgumentConverter argumentConverter;

    public CompositeArgumentResolver(FrameworkModel frameworkModel) {
        List extensions = frameworkModel.getActivateExtensions(ArgumentResolver.class);
        ArrayList<ArgumentResolver> resolvers = new ArrayList<ArgumentResolver>(extensions.size());
        for (ArgumentResolver resolver : extensions) {
            if (resolver instanceof AnnotationBaseArgumentResolver) {
                AnnotationBaseArgumentResolver aar = (AnnotationBaseArgumentResolver)resolver;
                this.resolverMap.put(aar.accept(), aar);
                continue;
            }
            resolvers.add(resolver);
        }
        this.resolvers = resolvers.toArray(new ArgumentResolver[0]);
        this.argumentConverter = new CompositeArgumentConverter(frameworkModel);
    }

    @Override
    public boolean accept(ParameterMeta parameter) {
        return true;
    }

    @Override
    public Object resolve(ParameterMeta parameter, HttpRequest request, HttpResponse response) {
        AnnotationMeta[] annotations = parameter.findAnnotations();
        for (AnnotationMeta annotation : annotations) {
            AnnotationBaseArgumentResolver resolver = this.resolverMap.get(annotation.getAnnotationType());
            if (resolver == null) continue;
            Object value = resolver.resolve(parameter, annotation, request, response);
            return this.argumentConverter.convert(value, parameter);
        }
        for (ArgumentResolver resolver : this.resolvers) {
            if (!resolver.accept(parameter)) continue;
            Object value = resolver.resolve(parameter, request, response);
            return this.argumentConverter.convert(value, parameter);
        }
        throw new IllegalStateException(Messages.ARGUMENT_COULD_NOT_RESOLVED.format(parameter.getDescription()));
    }

    public ArgumentConverter getArgumentConverter() {
        return this.argumentConverter;
    }
}

