/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h12;

import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.remoting.http12.HttpResult;
import org.apache.dubbo.remoting.http12.exception.HttpResultPayloadException;
import org.apache.dubbo.rpc.BaseFilter;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;

@Activate(group={"provider"}, order=29000)
public class HttpContextCallbackFilter
implements Filter,
BaseFilter.Listener {
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        return invoker.invoke(invocation);
    }

    public void onResponse(Result appResponse, Invoker<?> invoker, Invocation invocation) {
        Object handlerType = invocation.get((Object)"tri.handler.type");
        if (handlerType == null) {
            return;
        }
        Throwable exception = appResponse.getException();
        if (exception instanceof HttpResultPayloadException) {
            HttpResult value = "grpc".equals(handlerType) ? HttpResult.of((Object)exception) : ((HttpResultPayloadException)exception).getResult();
            appResponse.setValue((Object)value);
            appResponse.setException(null);
            return;
        }
        HttpResponse response = (HttpResponse)invocation.get((Object)"tri.http.response");
        if (response.isEmpty()) {
            return;
        }
        if (response.isContentEmpty()) {
            if (appResponse.hasException()) {
                return;
            }
            response.setBody(appResponse.getValue());
        }
        response.commit();
        HttpResult result = response.toHttpResult();
        if (result.getBody() instanceof Throwable) {
            appResponse.setException((Throwable)result.getBody());
        } else {
            appResponse.setValue((Object)result);
            appResponse.setException(null);
        }
    }

    public void onError(Throwable t, Invoker<?> invoker, Invocation invocation) {
    }
}

