/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h12;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.FluentLogger;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.common.threadpool.serial.SerializingExecutor;
import org.apache.dubbo.common.utils.MethodUtils;
import org.apache.dubbo.common.utils.UrlUtils;
import org.apache.dubbo.remoting.http12.HttpChannel;
import org.apache.dubbo.remoting.http12.HttpInputMessage;
import org.apache.dubbo.remoting.http12.HttpStatus;
import org.apache.dubbo.remoting.http12.HttpTransportListener;
import org.apache.dubbo.remoting.http12.RequestMetadata;
import org.apache.dubbo.remoting.http12.exception.HttpStatusException;
import org.apache.dubbo.remoting.http12.message.MethodMetadata;
import org.apache.dubbo.rpc.HeaderFilter;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.protocol.tri.DescriptorUtils;
import org.apache.dubbo.rpc.protocol.tri.ExceptionUtils;
import org.apache.dubbo.rpc.protocol.tri.RpcInvocationBuildContext;
import org.apache.dubbo.rpc.protocol.tri.TripleHeaderEnum;
import org.apache.dubbo.rpc.protocol.tri.TripleProtocol;
import org.apache.dubbo.rpc.protocol.tri.h12.ExceptionCustomizerWrapper;
import org.apache.dubbo.rpc.protocol.tri.h12.HttpMessageListener;
import org.apache.dubbo.rpc.protocol.tri.route.DefaultRequestRouter;
import org.apache.dubbo.rpc.protocol.tri.route.RequestRouter;
import org.apache.dubbo.rpc.protocol.tri.stream.StreamUtils;

public abstract class AbstractServerTransportListener<HEADER extends RequestMetadata, MESSAGE extends HttpInputMessage>
implements HttpTransportListener<HEADER, MESSAGE> {
    private static final FluentLogger LOGGER = FluentLogger.of(AbstractServerTransportListener.class);
    private static final String HEADER_FILTERS_CACHE = "HEADER_FILTERS_CACHE";
    private final FrameworkModel frameworkModel;
    private final URL url;
    private final HttpChannel httpChannel;
    private final RequestRouter requestRouter;
    private final ExceptionCustomizerWrapper exceptionCustomizerWrapper;
    private final List<HeaderFilter> headerFilters;
    private Executor executor;
    private HEADER httpMetadata;
    private RpcInvocationBuildContext context;
    private HttpMessageListener httpMessageListener;

    protected AbstractServerTransportListener(FrameworkModel frameworkModel, URL url, HttpChannel httpChannel) {
        this.frameworkModel = frameworkModel;
        this.url = url;
        this.httpChannel = httpChannel;
        this.requestRouter = (RequestRouter)frameworkModel.getBeanFactory().getOrRegisterBean(DefaultRequestRouter.class);
        this.exceptionCustomizerWrapper = new ExceptionCustomizerWrapper(frameworkModel);
        this.headerFilters = frameworkModel.getExtensionLoader(HeaderFilter.class).getActivateExtension(url, "header.filter");
    }

    public final void onMetadata(HEADER metadata) {
        this.httpMetadata = metadata;
        this.exceptionCustomizerWrapper.setMetadata((RequestMetadata)metadata);
        try {
            this.onBeforeMetadata(metadata);
        }
        catch (Throwable t) {
            this.logError(t);
            this.onMetadataError(metadata, t);
            return;
        }
        try {
            this.executor = this.initializeExecutor(this.url, metadata);
        }
        catch (Throwable t) {
            LOGGER.error("0-18", "Initialize executor failed.", t);
            this.onError(t);
            return;
        }
        if (this.executor == null) {
            LOGGER.internalError("Executor must not be null.");
            this.onError(new NullPointerException("Initialize executor return null"));
            return;
        }
        this.executor.execute(() -> {
            try {
                this.onPrepareMetadata(metadata);
                this.setHttpMessageListener(this.buildHttpMessageListener());
                this.onMetadataCompletion(metadata);
            }
            catch (Throwable t) {
                this.logError(t);
                this.onMetadataError(metadata, t);
            }
        });
    }

    protected void onBeforeMetadata(HEADER metadata) {
        this.doRoute(metadata);
    }

    protected final void doRoute(HEADER metadata) {
        this.context = this.requestRouter.route(this.url, (RequestMetadata)metadata, this.httpChannel);
        if (this.context == null) {
            throw new HttpStatusException(HttpStatus.NOT_FOUND.getCode(), "Invoker not found");
        }
        this.exceptionCustomizerWrapper.setMethodDescriptor(this.context.getMethodDescriptor());
    }

    protected Executor initializeExecutor(URL url, HEADER metadata) {
        url = this.context.getInvoker().getUrl();
        return this.getExecutor(url, url);
    }

    protected final Executor getExecutor(URL url, Object data) {
        return new SerializingExecutor(ExecutorRepository.getInstance((ApplicationModel)url.getOrDefaultApplicationModel()).getExecutorSupport(url).getExecutor(data));
    }

    protected void onPrepareMetadata(HEADER metadata) {
    }

    protected abstract HttpMessageListener buildHttpMessageListener();

    protected void onMetadataCompletion(HEADER metadata) {
    }

    protected void onMetadataError(HEADER metadata, Throwable throwable) {
        this.initializeAltSvc(this.url);
        this.onError(throwable);
    }

    protected void initializeAltSvc(URL url) {
    }

    public final void onData(MESSAGE message) {
        if (this.executor == null) {
            this.onDataFinally(message);
            return;
        }
        this.executor.execute(() -> {
            try {
                this.doOnData(message);
            }
            catch (Throwable t) {
                this.logError(t);
                this.onError(message, t);
            }
            finally {
                this.onDataFinally(message);
            }
        });
    }

    protected void doOnData(MESSAGE message) {
        if (this.httpMessageListener == null) {
            return;
        }
        this.onPrepareData(message);
        this.httpMessageListener.onMessage(message.getBody());
        this.onDataCompletion(message);
    }

    protected void onPrepareData(MESSAGE message) {
    }

    protected void onDataCompletion(MESSAGE message) {
    }

    protected void onDataFinally(MESSAGE message) {
        try {
            message.close();
        }
        catch (Exception e) {
            this.onError(e);
        }
    }

    protected void onError(MESSAGE message, Throwable throwable) {
        this.onError(throwable);
    }

    protected void onError(Throwable throwable) {
        throw ExceptionUtils.wrap(throwable);
    }

    private void logError(Throwable t) {
        Supplier<String> msg = () -> {
            StringBuilder sb = new StringBuilder(128);
            sb.append("An error occurred while processing the http request with ").append(this.getClass().getSimpleName()).append(", ").append(this.httpMetadata);
            if (TripleProtocol.VERBOSE_ENABLED) {
                sb.append(", headers=").append(this.httpMetadata.headers());
            }
            if (this.context != null) {
                Invoker<?> invoker;
                MethodDescriptor md = this.context.getMethodDescriptor();
                if (md != null) {
                    sb.append(", method=").append(MethodUtils.toShortString((MethodDescriptor)md));
                }
                if (TripleProtocol.VERBOSE_ENABLED && (invoker = this.context.getInvoker()) != null) {
                    URL url = invoker.getUrl();
                    Object service = url.getServiceModel().getProxyObject();
                    sb.append(", service=").append(service.getClass().getSimpleName()).append('@').append(Integer.toHexString(System.identityHashCode(service))).append(", url='").append(url).append('\'');
                }
            }
            return sb.toString();
        };
        Throwable th = ExceptionUtils.unwrap(t);
        LOGGER.msg(msg).log(this.exceptionCustomizerWrapper.resolveLogLevel(th), th);
    }

    protected final RpcInvocation buildRpcInvocation(RpcInvocationBuildContext context) {
        HeaderFilter[] headerFilters;
        MethodMetadata methodMetadata;
        MethodDescriptor methodDescriptor = context.getMethodDescriptor();
        if (methodDescriptor == null) {
            methodDescriptor = DescriptorUtils.findMethodDescriptor(context.getServiceDescriptor(), context.getMethodName(), context.isHasStub());
            this.setMethodDescriptor(methodDescriptor);
        }
        if ((methodMetadata = context.getMethodMetadata()) == null) {
            methodMetadata = MethodMetadata.fromMethodDescriptor((MethodDescriptor)methodDescriptor);
            context.setMethodMetadata(methodMetadata);
        }
        Invoker<?> invoker = context.getInvoker();
        URL url = invoker.getUrl();
        RpcInvocation inv = new RpcInvocation(url.getServiceModel(), methodDescriptor.getMethodName(), context.getServiceDescriptor().getInterfaceName(), url.getProtocolServiceKey(), methodDescriptor.getParameterClasses(), new Object[0]);
        inv.setTargetServiceUniqueName(url.getServiceKey());
        inv.setReturnTypes(methodDescriptor.getReturnTypes());
        inv.setObjectAttachments(StreamUtils.toAttachments(this.httpMetadata.headers()));
        inv.put((Object)"tri.remote.address", (Object)this.httpChannel.remoteAddress());
        inv.getAttributes().putAll(context.getAttributes());
        String consumerAppName = this.httpMetadata.header(TripleHeaderEnum.CONSUMER_APP_NAME_KEY.getKey());
        if (consumerAppName != null) {
            inv.put((Object)TripleHeaderEnum.CONSUMER_APP_NAME_KEY, (Object)consumerAppName);
        }
        for (HeaderFilter headerFilter : headerFilters = (HeaderFilter[])UrlUtils.computeServiceAttribute((URL)invoker.getUrl(), (String)HEADER_FILTERS_CACHE, this::loadHeaderFilters)) {
            headerFilter.invoke(invoker, inv);
        }
        this.initializeAltSvc(url);
        return this.onBuildRpcInvocationCompletion(inv);
    }

    private HeaderFilter[] loadHeaderFilters(URL url) {
        List headerFilters = this.frameworkModel.getExtensionLoader(HeaderFilter.class).getActivateExtension(url, "header.filter");
        LOGGER.info("Header filters for [{}] loaded: {}", new Object[]{url, headerFilters});
        return headerFilters.toArray(new HeaderFilter[0]);
    }

    protected RpcInvocation onBuildRpcInvocationCompletion(RpcInvocation invocation) {
        String timeoutString = this.httpMetadata.header(TripleHeaderEnum.SERVICE_TIMEOUT.getKey());
        try {
            if (timeoutString != null) {
                Long timeout = Long.parseLong(timeoutString);
                invocation.put((Object)"timeout", (Object)timeout);
            }
        }
        catch (Throwable t) {
            LOGGER.warn("4-9", "Failed to parse request timeout set from: {}, service={}, method={}", new Object[]{timeoutString, this.context.getServiceDescriptor().getInterfaceName(), this.context.getMethodName()});
        }
        return invocation;
    }

    protected final FrameworkModel getFrameworkModel() {
        return this.frameworkModel;
    }

    protected final ExceptionCustomizerWrapper getExceptionCustomizerWrapper() {
        return this.exceptionCustomizerWrapper;
    }

    protected final HEADER getHttpMetadata() {
        return this.httpMetadata;
    }

    public final RpcInvocationBuildContext getContext() {
        return this.context;
    }

    protected final void setHttpMessageListener(HttpMessageListener httpMessageListener) {
        this.httpMessageListener = httpMessageListener;
    }

    protected Function<Throwable, Object> getExceptionCustomizer() {
        return this.exceptionCustomizerWrapper::customize;
    }

    protected void setMethodDescriptor(MethodDescriptor methodDescriptor) {
        this.context.setMethodDescriptor(methodDescriptor);
        this.exceptionCustomizerWrapper.setMethodDescriptor(methodDescriptor);
    }
}

