/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.exception.DecodeException;
import org.apache.dubbo.remoting.http12.exception.EncodeException;
import org.apache.dubbo.remoting.http12.message.HttpMessageDecoder;
import org.apache.dubbo.remoting.http12.message.MediaType;
import org.apache.dubbo.rpc.protocol.tri.rest.RestConstants;

public final class RequestUtils {
    public static final String EMPTY_BODY = "";

    private RequestUtils() {
    }

    public static boolean isMultiPart(HttpRequest request) {
        String contentType = request.contentType();
        return contentType != null && contentType.startsWith(MediaType.MULTIPART_FORM_DATA.getName());
    }

    public static boolean isFormOrMultiPart(HttpRequest request) {
        String contentType = request.contentType();
        if (contentType == null) {
            return false;
        }
        return contentType.startsWith(MediaType.APPLICATION_FROM_URLENCODED.getName()) || contentType.startsWith(MediaType.MULTIPART_FORM_DATA.getName());
    }

    public static String decodeURL(String value) {
        try {
            return URLDecoder.decode(value, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new DecodeException((Throwable)e);
        }
    }

    public static String encodeURL(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new EncodeException((Throwable)e);
        }
    }

    public static Map<String, List<String>> getParametersMap(HttpRequest request) {
        Collection paramNames = request.parameterNames();
        if (paramNames.isEmpty()) {
            return Collections.emptyMap();
        }
        Map params = CollectionUtils.newLinkedHashMap((int)paramNames.size());
        for (String paramName : paramNames) {
            params.put(paramName, request.parameterValues(paramName));
        }
        return params;
    }

    public static Map<String, List<String>> getFormParametersMap(HttpRequest request) {
        Collection paramNames = request.formParameterNames();
        if (paramNames.isEmpty()) {
            return Collections.emptyMap();
        }
        Map params = CollectionUtils.newLinkedHashMap((int)paramNames.size());
        for (String paramName : paramNames) {
            params.put(paramName, request.formParameterValues(paramName));
        }
        return params;
    }

    public static Map<String, Object> getParametersMapStartingWith(HttpRequest request, String prefix) {
        Collection paramNames = request.parameterNames();
        if (paramNames.isEmpty()) {
            return Collections.emptyMap();
        }
        if (prefix == null) {
            prefix = EMPTY_BODY;
        }
        Map params = CollectionUtils.newLinkedHashMap((int)paramNames.size());
        for (String paramName : paramNames) {
            if (!prefix.isEmpty() && !paramName.startsWith(prefix)) continue;
            String name = paramName.substring(prefix.length());
            List values = request.parameterValues(paramName);
            if (CollectionUtils.isEmpty((Collection)values)) continue;
            params.put(name, values.size() == 1 ? values.get(0) : values);
        }
        return params;
    }

    public static Map<String, List<String>> parseMatrixVariables(String matrixVariables) {
        LinkedHashMap<String, List> result = null;
        StringTokenizer pairs = new StringTokenizer(matrixVariables, ";");
        while (pairs.hasMoreTokens()) {
            String pair = pairs.nextToken();
            int index = pair.indexOf(61);
            if (index == -1) {
                if (result == null) {
                    result = new LinkedHashMap<String, List>();
                }
                result.computeIfAbsent(pair, k -> new ArrayList()).add(EMPTY_BODY);
                continue;
            }
            String name = pair.substring(0, index);
            if ("jsessionid".equalsIgnoreCase(name)) continue;
            if (result == null) {
                result = new LinkedHashMap();
            }
            for (String value : StringUtils.tokenize((String)pair.substring(index + 1), (char[])new char[]{','})) {
                result.computeIfAbsent(name, k -> new ArrayList()).add(RequestUtils.decodeURL(value));
            }
        }
        return result;
    }

    public static List<String> parseMatrixVariableValues(Map<String, String> variableMap, String name) {
        if (variableMap == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = null;
        for (Map.Entry<String, String> entry : variableMap.entrySet()) {
            List<String> values;
            Map<String, List<String>> matrixVariables = RequestUtils.parseMatrixVariables(entry.getValue());
            if (matrixVariables == null || (values = matrixVariables.get(name)) == null) continue;
            if (result == null) {
                result = new ArrayList<String>();
            }
            result.addAll(values);
        }
        return result == null ? Collections.emptyList() : result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object decodeBody(HttpRequest request, Type type) {
        HttpMessageDecoder decoder = (HttpMessageDecoder)request.attribute(RestConstants.BODY_DECODER_ATTRIBUTE);
        if (decoder == null) {
            return null;
        }
        if (decoder.mediaType().isPureText()) {
            type = String.class;
        }
        InputStream is = request.inputStream();
        try {
            int available = is.available();
            if (available == 0) {
                if (type instanceof Class) {
                    Class clazz = (Class)type;
                    if (clazz == String.class) {
                        return EMPTY_BODY;
                    }
                    if (clazz == byte[].class) {
                        return new byte[0];
                    }
                }
                return null;
            }
        }
        catch (IOException e) {
            throw new DecodeException("Error reading is", (Throwable)e);
        }
        boolean canMark = is.markSupported();
        try {
            if (canMark) {
                is.mark(Integer.MAX_VALUE);
            }
            Object object = decoder.decode(is, (Type)type, request.charsetOrDefault());
            return object;
        }
        finally {
            try {
                if (canMark) {
                    is.reset();
                } else {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static Object decodeBodyAsObject(HttpRequest request) {
        Object value = request.attribute(RestConstants.BODY_ATTRIBUTE);
        if (value == null && (value = RequestUtils.decodeBody(request, Object.class)) != null) {
            request.setAttribute(RestConstants.BODY_ATTRIBUTE, value);
        }
        return value;
    }
}

