/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.dubbo.rpc.protocol.tri.rest.Messages;
import org.apache.dubbo.rpc.protocol.tri.rest.PathParserException;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.PathSegment;
import org.apache.dubbo.rpc.protocol.tri.rest.util.PathUtils;

final class PathParser {
    private static final PathSegment SLASH = new PathSegment(PathSegment.Type.SLASH, "/");
    private final List<PathSegment> segments = new LinkedList<PathSegment>();
    private final StringBuilder buf = new StringBuilder();

    PathParser() {
    }

    static PathSegment[] parse(String path) {
        if (path == null || path.isEmpty() || "/".equals(path)) {
            return new PathSegment[]{PathSegment.literal("/")};
        }
        if (PathUtils.isDirectPath(path)) {
            return new PathSegment[]{PathSegment.literal(path)};
        }
        List<PathSegment> segments = new PathParser().doParse(path);
        return segments.toArray(new PathSegment[0]);
    }

    private List<PathSegment> doParse(String path) {
        this.parseSegments(path);
        PathParser.transformSegments(this.segments, path);
        for (PathSegment segment : this.segments) {
            try {
                segment.initPattern();
            }
            catch (Exception e) {
                throw new PathParserException(Messages.REGEX_PATTERN_INVALID, segment.getValue(), path, e);
            }
        }
        return this.segments;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseSegments(String path) {
        int state = 0;
        boolean regexBraceStart = false;
        boolean regexMulti = false;
        String variableName = null;
        int len = path.length();
        block41: for (int i = 0; i < len; ++i) {
            char c = path.charAt(i);
            block0 : switch (c) {
                case '/': {
                    switch (state) {
                        case 0: 
                        case 6: {
                            continue block41;
                        }
                        case 1: {
                            if (this.buf.length() <= 0) break;
                            this.appendSegment(PathSegment.Type.LITERAL);
                            break;
                        }
                        case 2: {
                            this.appendSegment(PathSegment.Type.WILDCARD);
                            break;
                        }
                        case 4: {
                            if (path.charAt(i - 1) != '^' || path.charAt(i - 2) != '[') {
                                regexMulti = true;
                            }
                            this.buf.append(c);
                            continue block41;
                        }
                        case 3: 
                        case 5: {
                            throw new PathParserException(Messages.MISSING_CLOSE_CAPTURE, path, i);
                        }
                    }
                    this.segments.add(SLASH);
                    state = 6;
                    continue block41;
                }
                case '?': {
                    switch (state) {
                        case 0: 
                        case 1: 
                        case 6: {
                            state = 2;
                            break block0;
                        }
                    }
                    break;
                }
                case '*': {
                    switch (state) {
                        case 0: 
                        case 1: 
                        case 6: {
                            state = 2;
                            break;
                        }
                        case 3: {
                            if (path.charAt(i - 1) != '{') break;
                            state = 5;
                            continue block41;
                        }
                    }
                    break;
                }
                case '.': {
                    if (state != 4 || path.charAt(i - 1) == '\\') break;
                    regexMulti = true;
                    break;
                }
                case 'S': 
                case 'W': {
                    if (state != 4 || path.charAt(i - 1) != '\\') break;
                    regexMulti = true;
                    break;
                }
                case ':': {
                    if (state != 3) break;
                    state = 4;
                    variableName = this.buf.toString();
                    this.buf.setLength(0);
                    continue block41;
                }
                case '{': {
                    switch (state) {
                        case 0: 
                        case 6: {
                            state = 3;
                            continue block41;
                        }
                        case 1: {
                            if (this.buf.length() > 0) {
                                this.appendSegment(PathSegment.Type.LITERAL);
                            }
                            state = 3;
                            continue block41;
                        }
                        case 3: 
                        case 5: {
                            throw new PathParserException(Messages.ILLEGAL_NESTED_CAPTURE, path, i);
                        }
                        case 4: {
                            if (path.charAt(i - 1) == '\\') break;
                            regexBraceStart = true;
                            break;
                        }
                    }
                    break;
                }
                case '}': {
                    switch (state) {
                        case 0: 
                        case 1: 
                        case 6: {
                            throw new PathParserException(Messages.MISSING_OPEN_CAPTURE, path);
                        }
                        case 3: {
                            this.appendSegment(PathSegment.Type.VARIABLE, this.buf.toString());
                            state = 1;
                            continue block41;
                        }
                        case 4: {
                            if (regexBraceStart) {
                                regexBraceStart = false;
                                break;
                            }
                            if (this.buf.length() == 0) {
                                throw new PathParserException(Messages.MISSING_REGEX_CONSTRAINT, path, i);
                            }
                            this.appendSegment(regexMulti ? PathSegment.Type.PATTERN_MULTI : PathSegment.Type.PATTERN, variableName);
                            regexMulti = false;
                            state = 1;
                            continue block41;
                        }
                        case 5: {
                            this.appendSegment(PathSegment.Type.WILDCARD_TAIL, this.buf.toString());
                            state = 7;
                            continue block41;
                        }
                    }
                    break;
                }
                default: {
                    if (state != 0 && state != 6) break;
                    state = 1;
                }
            }
            if (state == 7) {
                throw new PathParserException(Messages.NO_MORE_DATA_ALLOWED, path, i);
            }
            this.buf.append(c);
        }
        if (this.buf.length() <= 0) return;
        switch (state) {
            case 1: {
                this.appendSegment(PathSegment.Type.LITERAL);
                return;
            }
            case 2: {
                this.appendSegment(PathSegment.Type.WILDCARD);
                return;
            }
            case 3: 
            case 4: 
            case 5: {
                throw new PathParserException(Messages.MISSING_CLOSE_CAPTURE, path, len - 1);
            }
        }
    }

    private void appendSegment(PathSegment.Type type) {
        this.segments.add(new PathSegment(type, this.buf.toString()));
        this.buf.setLength(0);
    }

    private void appendSegment(PathSegment.Type type, String name) {
        this.segments.add(new PathSegment(type, this.buf.toString().trim(), name.trim()));
        this.buf.setLength(0);
    }

    private static void transformSegments(List<PathSegment> segments, String path) {
        ListIterator<PathSegment> iterator = segments.listIterator();
        PathSegment prev = null;
        block31: while (iterator.hasNext()) {
            PathSegment curr = iterator.next();
            String value = curr.getValue();
            PathSegment.Type type = curr.getType();
            switch (type) {
                case SLASH: {
                    if (prev != null) {
                        switch (prev.getType()) {
                            case LITERAL: 
                            case VARIABLE: 
                            case PATTERN: {
                                prev = curr;
                                break;
                            }
                            case PATTERN_MULTI: {
                                if (".*".equals(prev.getValue())) break;
                                prev.setValue(prev.getValue() + '/');
                                break;
                            }
                        }
                    }
                    iterator.remove();
                    continue block31;
                }
                case WILDCARD: {
                    if ("*".equals(value)) {
                        type = PathSegment.Type.VARIABLE;
                        value = "";
                    } else if ("**".equals(value)) {
                        if (!iterator.hasNext()) {
                            type = PathSegment.Type.WILDCARD_TAIL;
                            value = "";
                        } else {
                            type = PathSegment.Type.PATTERN_MULTI;
                            value = ".*";
                        }
                    } else {
                        type = PathSegment.Type.PATTERN;
                        value = PathParser.toRegex(value);
                    }
                    curr.setType(type);
                    curr.setValue(value);
                    break;
                }
                case WILDCARD_TAIL: {
                    break;
                }
                case PATTERN: 
                case PATTERN_MULTI: {
                    curr.setValue("(?<" + curr.getVariable() + '>' + value + ')');
                    break;
                }
            }
            if (prev == null) {
                prev = curr;
                continue;
            }
            String pValue = prev.getValue();
            switch (prev.getType()) {
                case LITERAL: {
                    switch (type) {
                        case VARIABLE: {
                            prev.setType(PathSegment.Type.PATTERN);
                            prev.setValue(PathParser.quoteRegex(pValue) + "(?<" + curr.getVariable() + ">[^/]+)");
                            prev.setVariables(curr.getVariables());
                            iterator.remove();
                            continue block31;
                        }
                        case PATTERN: 
                        case PATTERN_MULTI: {
                            prev.setType(type);
                            prev.setValue(PathParser.quoteRegex(pValue) + "(?<" + curr.getVariable() + '>' + value + ')');
                            prev.setVariables(curr.getVariables());
                            iterator.remove();
                            continue block31;
                        }
                    }
                    break;
                }
                case VARIABLE: {
                    switch (type) {
                        case LITERAL: {
                            prev.setType(PathSegment.Type.PATTERN);
                            prev.setValue("(?<" + prev.getVariable() + ">[^/]+)" + PathParser.quoteRegex(value));
                            iterator.remove();
                            continue block31;
                        }
                        case VARIABLE: {
                            throw new PathParserException(Messages.ILLEGAL_DOUBLE_CAPTURE, path);
                        }
                        case PATTERN: 
                        case PATTERN_MULTI: {
                            String var = curr.getVariable();
                            prev.addVariable(var);
                            prev.setType(type);
                            prev.setValue("(?<" + prev.getVariable() + ">[^/]+)(?<" + var + '>' + value + ')');
                            iterator.remove();
                            continue block31;
                        }
                    }
                    break;
                }
                case PATTERN: 
                case PATTERN_MULTI: {
                    switch (type) {
                        case LITERAL: {
                            prev.setValue(pValue + PathParser.quoteRegex(value));
                            iterator.remove();
                            continue block31;
                        }
                        case WILDCARD_TAIL: {
                            if (curr.getVariables() == null) {
                                prev.setValue(pValue + ".*");
                            } else {
                                prev.addVariable(curr.getVariable());
                                prev.setValue(pValue + "(?<" + curr.getVariable() + ">.*)");
                            }
                            prev.setType(PathSegment.Type.PATTERN_MULTI);
                            iterator.remove();
                            continue block31;
                        }
                        case VARIABLE: {
                            if (value.isEmpty()) {
                                prev.setValue(pValue + "[^/]+");
                                iterator.remove();
                                continue block31;
                            }
                            prev.addVariable(curr.getVariable());
                            prev.setValue(pValue + "(?<" + curr.getVariable() + ">[^/]+)");
                            iterator.remove();
                            continue block31;
                        }
                        case PATTERN_MULTI: {
                            prev.setType(PathSegment.Type.PATTERN_MULTI);
                        }
                        case PATTERN: {
                            if (curr.getVariables() == null) {
                                prev.setValue(pValue + value);
                            } else {
                                prev.addVariable(curr.getVariable());
                                prev.setValue(pValue + "(?<" + curr.getVariable() + '>' + value + ')');
                            }
                            iterator.remove();
                            continue block31;
                        }
                    }
                    break;
                }
            }
            prev = curr;
        }
    }

    private static String quoteRegex(String regex) {
        int len = regex.length();
        for (int i = 0; i < len; ++i) {
            switch (regex.charAt(i)) {
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    return "\\Q" + regex + "\\E";
                }
            }
        }
        return regex;
    }

    private static String toRegex(String wildcard) {
        int len = wildcard.length();
        StringBuilder sb = new StringBuilder(len + 8);
        block5: for (int i = 0; i < len; ++i) {
            char c = wildcard.charAt(i);
            switch (c) {
                case '*': {
                    if (i > 0) {
                        char prev = wildcard.charAt(i - 1);
                        if (prev == '*') continue block5;
                        if (prev == '?') {
                            sb.append("*");
                            continue block5;
                        }
                    }
                    sb.append("[^/]*");
                    continue block5;
                }
                case '?': {
                    if (i > 0 && wildcard.charAt(i - 1) == '*') continue block5;
                    sb.append("[^/]");
                    continue block5;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '\\': 
                case '{': 
                case '|': 
                case '}': {
                    sb.append('\\');
                    sb.append(c);
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private static interface State {
        public static final int INITIAL = 0;
        public static final int LITERAL_START = 1;
        public static final int WILDCARD_START = 2;
        public static final int VARIABLE_START = 3;
        public static final int REGEX_VARIABLE_START = 4;
        public static final int WILDCARD_VARIABLE_START = 5;
        public static final int SEGMENT_END = 6;
        public static final int END = 7;
    }
}

