/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h3.negotiation;

import io.netty.util.AsciiString;
import java.net.InetSocketAddress;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.api.connection.AbstractConnectionClient;
import org.apache.dubbo.rpc.protocol.tri.TripleConstants;
import org.apache.dubbo.rpc.protocol.tri.h3.negotiation.Helper;
import org.apache.dubbo.rpc.protocol.tri.h3.negotiation.NegotiateClientCall;

public class AutoSwitchConnectionClient
extends AbstractConnectionClient {
    private static final ErrorTypeAwareLogger LOGGER = LoggerFactory.getErrorTypeAwareLogger(AutoSwitchConnectionClient.class);
    private static final int MAX_RETRIES = 8;
    private final URL url;
    private final AbstractConnectionClient connectionClient;
    private AbstractConnectionClient http3ConnectionClient;
    private ScheduledExecutorService executor;
    private NegotiateClientCall clientCall;
    private boolean negotiated = false;
    private boolean http3Connected = false;
    private final AtomicBoolean scheduling = new AtomicBoolean();
    private int attempt = 0;

    public AutoSwitchConnectionClient(URL url, AbstractConnectionClient connectionClient) {
        this.url = url;
        this.connectionClient = connectionClient;
        this.executor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("Dubbo-http3-negotiation"));
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        connectionClient.addConnectedListener(() -> ClassUtils.runWith((ClassLoader)tccl, () -> this.executor.execute(this::negotiate)));
        this.increase();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Start HTTP/3 AutoSwitchConnectionClient {} connect to the server {}", new Object[]{NetUtils.getLocalAddress(), url.toInetSocketAddress()});
        }
    }

    private String getBaseUrl() {
        boolean ssl = this.url.getParameter("ssl-enabled", false);
        AsciiString scheme = ssl ? TripleConstants.HTTPS_SCHEME : TripleConstants.HTTP_SCHEME;
        return scheme + "://" + this.url.getHost() + ':' + this.url.getPort() + '/';
    }

    private void negotiate() {
        if (this.negotiated) {
            return;
        }
        this.scheduling.set(false);
        if (this.clientCall == null) {
            this.clientCall = new NegotiateClientCall(this.connectionClient, this.executor);
        }
        LOGGER.info("Start HTTP/3 negotiation for [{}]", new Object[]{this.getBaseUrl()});
        this.clientCall.start(this.url).whenComplete((altSvc, t) -> {
            if (t == null) {
                if (altSvc.contains("h3=")) {
                    this.negotiateSuccess();
                    return;
                }
                LOGGER.info("HTTP/3 negotiation succeed, but provider reply alt-svc='{}' not support HTTP/3 for [{}]", new Object[]{altSvc, this.getBaseUrl()});
                return;
            }
            if (this.scheduling.compareAndSet(false, true)) {
                this.reScheduleNegotiate((Throwable)t);
            }
        });
    }

    private void negotiateSuccess() {
        this.negotiated = true;
        LOGGER.info("HTTP/3 negotiation succeed for [{}], create http3 client", new Object[]{this.getBaseUrl()});
        this.http3ConnectionClient = Helper.createHttp3Client(this.url, this.connectionClient.getDelegateHandler());
        this.http3ConnectionClient.addConnectedListener(() -> this.setHttp3Connected(true));
        this.http3ConnectionClient.addDisconnectedListener(() -> this.setHttp3Connected(false));
        this.negotiateEnd();
    }

    private void reScheduleNegotiate(Throwable t) {
        if (this.attempt++ < 8) {
            int delay = 1 << this.attempt + 2;
            LOGGER.info("HTTP/3 negotiation failed, retry after {} seconds for [{}]", new Object[]{delay, this.getBaseUrl(), t});
            this.executor.schedule(this::negotiate, (long)delay, TimeUnit.SECONDS);
            return;
        }
        LOGGER.warn("4-7", "", "", "Max retries 8 reached, HTTP/3 negotiation failed for " + this.getBaseUrl(), t);
        this.negotiateEnd();
    }

    private void negotiateEnd() {
        this.scheduling.set(false);
        this.executor.shutdown();
        this.executor = null;
        this.clientCall = null;
    }

    private void setHttp3Connected(boolean http3Connected) {
        this.http3Connected = http3Connected;
        LOGGER.info("Switch protocol to {} for [{}]", new Object[]{http3Connected ? "HTTP/3" : "HTTP/2", this.url.toString(new String[]{""})});
    }

    public boolean isHttp3Connected() {
        return this.http3Connected;
    }

    public boolean isConnected() {
        return this.http3Connected ? this.http3ConnectionClient.isConnected() : this.connectionClient.isConnected();
    }

    public InetSocketAddress getLocalAddress() {
        return this.http3Connected ? this.http3ConnectionClient.getLocalAddress() : this.connectionClient.getLocalAddress();
    }

    public boolean release() {
        try {
            this.connectionClient.release();
        }
        catch (Throwable t) {
            LOGGER.warn("4-7", "", "", t.getMessage(), t);
        }
        if (this.http3ConnectionClient != null) {
            try {
                this.http3ConnectionClient.release();
            }
            catch (Throwable t) {
                LOGGER.warn("4-7", "", "", t.getMessage(), t);
            }
        }
        return true;
    }

    protected void initConnectionClient() {
        throw new UnsupportedOperationException();
    }

    public boolean isAvailable() {
        return this.http3Connected ? this.http3ConnectionClient.isAvailable() : this.connectionClient.isAvailable();
    }

    public void addCloseListener(Runnable func) {
        this.connectionClient.addCloseListener(func);
    }

    public void addConnectedListener(Runnable func) {
        throw new UnsupportedOperationException();
    }

    public void addDisconnectedListener(Runnable func) {
        throw new UnsupportedOperationException();
    }

    public void onConnected(Object channel) {
        throw new UnsupportedOperationException();
    }

    public void onGoaway(Object channel) {
        throw new UnsupportedOperationException();
    }

    public void destroy() {
        this.connectionClient.destroy();
        if (this.http3ConnectionClient != null) {
            this.http3ConnectionClient.destroy();
        }
    }

    public <T> T getChannel(Boolean generalizable) {
        return (T)(this.http3Connected ? this.http3ConnectionClient.getChannel(generalizable) : this.connectionClient.getChannel(generalizable));
    }

    protected void doOpen() {
        throw new UnsupportedOperationException();
    }

    protected void doClose() {
        throw new UnsupportedOperationException();
    }

    protected void doConnect() {
        throw new UnsupportedOperationException();
    }

    protected void doDisConnect() {
        throw new UnsupportedOperationException();
    }

    protected Channel getChannel() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "AutoSwitchConnectionClient{http3Enabled=" + this.http3Connected + ", http3=" + this.http3ConnectionClient + ", http2=" + this.connectionClient + '}';
    }
}

