/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h12.http2;

import java.io.InputStream;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.stream.StreamObserver;
import org.apache.dubbo.remoting.http12.FlowControlStreamObserver;
import org.apache.dubbo.remoting.http12.HttpChannel;
import org.apache.dubbo.remoting.http12.HttpHeaderNames;
import org.apache.dubbo.remoting.http12.h2.CancelStreamException;
import org.apache.dubbo.remoting.http12.h2.H2StreamChannel;
import org.apache.dubbo.remoting.http12.h2.Http2Header;
import org.apache.dubbo.remoting.http12.h2.Http2InputMessage;
import org.apache.dubbo.remoting.http12.h2.Http2ServerChannelObserver;
import org.apache.dubbo.remoting.http12.h2.Http2TransportListener;
import org.apache.dubbo.remoting.http12.message.DefaultListeningDecoder;
import org.apache.dubbo.remoting.http12.message.DefaultStreamingDecoder;
import org.apache.dubbo.remoting.http12.message.HttpMessageEncoder;
import org.apache.dubbo.remoting.http12.message.ListeningDecoder;
import org.apache.dubbo.remoting.http12.message.StreamingDecoder;
import org.apache.dubbo.remoting.http12.message.codec.JsonCodec;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.protocol.tri.Http3Exchanger;
import org.apache.dubbo.rpc.protocol.tri.RpcInvocationBuildContext;
import org.apache.dubbo.rpc.protocol.tri.h12.AbstractServerTransportListener;
import org.apache.dubbo.rpc.protocol.tri.h12.BiStreamServerCallListener;
import org.apache.dubbo.rpc.protocol.tri.h12.HttpMessageListener;
import org.apache.dubbo.rpc.protocol.tri.h12.ServerCallListener;
import org.apache.dubbo.rpc.protocol.tri.h12.ServerStreamServerCallListener;
import org.apache.dubbo.rpc.protocol.tri.h12.UnaryServerCallListener;
import org.apache.dubbo.rpc.protocol.tri.h12.http2.Http2StreamServerChannelObserver;
import org.apache.dubbo.rpc.protocol.tri.h12.http2.Http2UnaryServerChannelObserver;

public class GenericHttp2ServerTransportListener
extends AbstractServerTransportListener<Http2Header, Http2InputMessage>
implements Http2TransportListener {
    private final H2StreamChannel h2StreamChannel;
    private final StreamingDecoder streamingDecoder;
    private Http2ServerChannelObserver responseObserver;
    private ServerCallListener serverCallListener;

    public GenericHttp2ServerTransportListener(H2StreamChannel h2StreamChannel, URL url, FrameworkModel frameworkModel) {
        super(frameworkModel, url, (HttpChannel)h2StreamChannel);
        this.h2StreamChannel = h2StreamChannel;
        this.streamingDecoder = this.newStreamingDecoder();
        this.responseObserver = this.prepareResponseObserver(this.newResponseObserver(h2StreamChannel));
    }

    protected StreamingDecoder newStreamingDecoder() {
        return new DefaultStreamingDecoder();
    }

    protected Http2ServerChannelObserver newResponseObserver(H2StreamChannel h2StreamChannel) {
        return new Http2UnaryServerChannelObserver(this.getFrameworkModel(), h2StreamChannel);
    }

    protected Http2ServerChannelObserver newStreamResponseObserver(H2StreamChannel h2StreamChannel) {
        return new Http2StreamServerChannelObserver(this.getFrameworkModel(), h2StreamChannel);
    }

    protected Http2ServerChannelObserver prepareResponseObserver(Http2ServerChannelObserver responseObserver) {
        responseObserver.setExceptionCustomizer(this.getExceptionCustomizer());
        RpcInvocationBuildContext context = this.getContext();
        responseObserver.setResponseEncoder((HttpMessageEncoder)(context == null ? JsonCodec.INSTANCE : context.getHttpMessageEncoder()));
        responseObserver.setCancellationContext(RpcContext.getCancellationContext());
        responseObserver.setStreamingDecoder(this.streamingDecoder);
        return responseObserver;
    }

    @Override
    protected HttpMessageListener buildHttpMessageListener() {
        RpcInvocationBuildContext context = this.getContext();
        RpcInvocation rpcInvocation = this.buildRpcInvocation(context);
        this.serverCallListener = this.startListener(rpcInvocation, context.getMethodDescriptor(), context.getInvoker());
        DefaultListeningDecoder listeningDecoder = new DefaultListeningDecoder(context.getHttpMessageDecoder(), context.getMethodMetadata().getActualRequestTypes());
        listeningDecoder.setListener((ListeningDecoder.Listener)new Http2StreamingDecodeListener(this.serverCallListener));
        this.streamingDecoder.setFragmentListener((StreamingDecoder.FragmentListener)new StreamingDecoder.DefaultFragmentListener((ListeningDecoder)listeningDecoder));
        return new StreamingHttpMessageListener(this.streamingDecoder);
    }

    private ServerCallListener startListener(RpcInvocation invocation, MethodDescriptor methodDescriptor, Invoker<?> invoker) {
        switch (methodDescriptor.getRpcType()) {
            case UNARY: {
                this.prepareUnaryServerCall();
                return new UnaryServerCallListener(invocation, invoker, (StreamObserver<Object>)this.responseObserver);
            }
            case SERVER_STREAM: {
                this.prepareStreamServerCall();
                return new ServerStreamServerCallListener(invocation, invoker, (StreamObserver<Object>)this.responseObserver);
            }
            case BI_STREAM: 
            case CLIENT_STREAM: {
                this.prepareStreamServerCall();
                return new BiStreamServerCallListener(invocation, invoker, (FlowControlStreamObserver<Object>)this.responseObserver);
            }
        }
        throw new IllegalStateException("Can not reach here");
    }

    protected void prepareUnaryServerCall() {
    }

    protected void prepareStreamServerCall() {
        this.responseObserver = this.prepareResponseObserver(this.newStreamResponseObserver(this.h2StreamChannel));
    }

    @Override
    protected void initializeAltSvc(URL url) {
        if (Http3Exchanger.isEnabled(url)) {
            String value = "h3=\":" + url.getParameter("bind.port", url.getPort()) + '\"';
            this.responseObserver.addHeadersCustomizer((hs, t) -> hs.set((CharSequence)HttpHeaderNames.ALT_SVC.getName(), value));
        }
    }

    @Override
    protected void onMetadataCompletion(Http2Header metadata) {
        this.responseObserver.setResponseEncoder(this.getContext().getHttpMessageEncoder());
        this.responseObserver.request(1);
        if (metadata.isEndStream()) {
            this.getStreamingDecoder().close();
        }
    }

    @Override
    protected void onDataCompletion(Http2InputMessage message) {
        if (message.isEndStream()) {
            this.getStreamingDecoder().close();
        }
    }

    @Override
    protected void onError(Throwable throwable) {
        this.responseObserver.onError(throwable);
    }

    @Override
    protected void onError(Http2InputMessage message, Throwable throwable) {
        try {
            message.close();
        }
        catch (Exception e) {
            throwable.addSuppressed(e);
        }
        this.onError(throwable);
    }

    @Override
    protected void onDataFinally(Http2InputMessage message) {
    }

    public void cancelByRemote(long errorCode) {
        this.responseObserver.cancel((Throwable)CancelStreamException.fromRemote((long)errorCode));
        if (this.serverCallListener != null) {
            this.serverCallListener.onCancel(errorCode);
        }
    }

    protected final StreamingDecoder getStreamingDecoder() {
        return this.streamingDecoder;
    }

    protected final Http2ServerChannelObserver getResponseObserver() {
        return this.responseObserver;
    }

    public void close() {
        this.responseObserver.close();
    }

    private static final class Http2StreamingDecodeListener
    implements ListeningDecoder.Listener {
        private final ServerCallListener serverCallListener;

        Http2StreamingDecodeListener(ServerCallListener serverCallListener) {
            this.serverCallListener = serverCallListener;
        }

        public void onMessage(Object message) {
            this.serverCallListener.onMessage(message);
        }

        public void onClose() {
            this.serverCallListener.onComplete();
        }
    }

    private static final class StreamingHttpMessageListener
    implements HttpMessageListener {
        private final StreamingDecoder streamingDecoder;

        StreamingHttpMessageListener(StreamingDecoder streamingDecoder) {
            this.streamingDecoder = streamingDecoder;
        }

        @Override
        public void onMessage(InputStream inputStream) {
            this.streamingDecoder.decode(inputStream);
        }
    }
}

