/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.support;

import java.lang.reflect.Constructor;
import org.apache.dubbo.rpc.RpcException;

public class Dubbo2RpcExceptionUtils {
    private static final Class<? extends RpcException> RPC_EXCEPTION_CLASS = Dubbo2RpcExceptionUtils.loadClass();
    private static final Constructor<? extends RpcException> RPC_EXCEPTION_CONSTRUCTOR_I_S_T = Dubbo2RpcExceptionUtils.loadConstructor(Integer.TYPE, String.class, Throwable.class);

    private static Class<? extends RpcException> loadClass() {
        try {
            Class<?> clazz = Class.forName("com.alibaba.dubbo.rpc.RpcException");
            if (RpcException.class.isAssignableFrom(clazz)) {
                return clazz;
            }
            return null;
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static Constructor<? extends RpcException> loadConstructor(Class<?> ... parameterTypes) {
        if (RPC_EXCEPTION_CLASS == null) {
            return null;
        }
        try {
            return RPC_EXCEPTION_CLASS.getConstructor(parameterTypes);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static boolean isRpcExceptionClassLoaded() {
        return RPC_EXCEPTION_CLASS != null && RPC_EXCEPTION_CONSTRUCTOR_I_S_T != null;
    }

    public static Class<? extends RpcException> getRpcExceptionClass() {
        return RPC_EXCEPTION_CLASS;
    }

    public static RpcException newRpcException(int code, String message, Throwable cause) {
        if (RPC_EXCEPTION_CONSTRUCTOR_I_S_T == null) {
            return null;
        }
        try {
            return RPC_EXCEPTION_CONSTRUCTOR_I_S_T.newInstance(code, message, cause);
        }
        catch (Throwable e) {
            return null;
        }
    }
}

