/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.support;

import java.util.Set;
import org.apache.dubbo.rpc.support.TrieNode;

public class TrieTree {
    private final TrieNode root = new TrieNode();

    public TrieTree(Set<String> words) {
        for (String word : words) {
            this.insert(word);
        }
    }

    private void insert(String word) {
        TrieNode node = this.root;
        for (char ch : word.toCharArray()) {
            int index = this.getCharIndex(ch);
            if (index == -1) {
                return;
            }
            if (node.children[index] == null) {
                node.children[index] = new TrieNode();
            }
            node = node.children[index];
        }
        node.isEndOfWord = true;
    }

    public boolean search(String word) {
        TrieNode node = this.root;
        for (char ch : word.toCharArray()) {
            int index = this.getCharIndex(ch);
            if (index == -1 || node.children[index] == null) {
                return false;
            }
            node = node.children[index];
        }
        return node.isEndOfWord;
    }

    private int getCharIndex(char ch) {
        if (ch >= 'A' && ch <= 'Z') {
            ch = (char)(ch + 32);
        }
        if (ch >= 'a' && ch <= 'z') {
            return ch - 97;
        }
        if (ch == '-') {
            return 26;
        }
        if (ch == '_') {
            return 27;
        }
        if (ch == '.') {
            return 28;
        }
        return -1;
    }
}

