/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.filter;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.BaseFilter;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcContextAttachment;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.RpcServiceContext;
import org.apache.dubbo.rpc.TimeoutCountDown;
import org.apache.dubbo.rpc.support.RpcUtils;

@Activate(group={"provider"}, order=-10000)
public class ContextFilter
implements Filter,
BaseFilter.Listener {
    private static final String TAG_KEY = "dubbo.tag";
    private static final Set<String> UNLOADING_KEYS = new HashSet<String>(16);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        Map<String, Object> attachments = invocation.getObjectAttachments();
        if (attachments != null) {
            HashMap<String, Object> newAttach = new HashMap<String, Object>(attachments.size());
            for (Map.Entry<String, Object> entry : attachments.entrySet()) {
                String key = entry.getKey();
                if (UNLOADING_KEYS.contains(key)) continue;
                newAttach.put(key, entry.getValue());
            }
            attachments = newAttach;
        }
        ((RpcServiceContext)RpcContext.getServiceContext().setInvoker((Invoker)invoker)).setInvocation(invocation);
        RpcContextAttachment context = RpcContext.getServerAttachment();
        context.setLocalAddress(invoker.getUrl().getHost(), invoker.getUrl().getPort());
        String remoteApplication = invocation.getAttachment("remote.application");
        if (StringUtils.isNotEmpty((String)remoteApplication)) {
            RpcContext.getServiceContext().setRemoteApplicationName(remoteApplication);
        } else {
            RpcContext.getServiceContext().setRemoteApplicationName(((RpcContext)context).getAttachment("remote.application"));
        }
        long timeout = RpcUtils.getTimeout(invocation, -1L);
        if (timeout != -1L) {
            RpcContext.getClientAttachment().setObjectAttachment("timeout-countdown", TimeoutCountDown.newCountDown(timeout, TimeUnit.MILLISECONDS));
        }
        if (attachments != null) {
            if (((RpcContext)context).getObjectAttachments() != null) {
                ((RpcContext)context).getObjectAttachments().putAll(attachments);
            } else {
                ((RpcContext)context).setObjectAttachments(attachments);
            }
        }
        if (invocation instanceof RpcInvocation) {
            ((RpcInvocation)invocation).setInvoker(invoker);
        }
        try {
            context.clearAfterEachInvoke(false);
            Result result = invoker.invoke(invocation);
            return result;
        }
        finally {
            context.clearAfterEachInvoke(true);
            RpcContext.removeServerAttachment();
            RpcContext.removeServiceContext();
            RpcContext.getClientAttachment().removeAttachment("timeout-countdown");
            RpcContext.removeServerContext();
        }
    }

    @Override
    public void onResponse(Result appResponse, Invoker<?> invoker, Invocation invocation) {
        appResponse.addObjectAttachments(RpcContext.getServerContext().getObjectAttachments());
    }

    @Override
    public void onError(Throwable t, Invoker<?> invoker, Invocation invocation) {
    }

    static {
        UNLOADING_KEYS.add("path");
        UNLOADING_KEYS.add("interface");
        UNLOADING_KEYS.add("group");
        UNLOADING_KEYS.add("version");
        UNLOADING_KEYS.add("dubbo");
        UNLOADING_KEYS.add("token");
        UNLOADING_KEYS.add("timeout");
        UNLOADING_KEYS.add("_TO");
        UNLOADING_KEYS.add("async");
        UNLOADING_KEYS.add(TAG_KEY);
        UNLOADING_KEYS.add("dubbo.force.tag");
    }
}

